	PAGE	60,132
	TITLE	CALENDAR_ROM
;*******UPDATE 83/07/28 (ADJUST LOOPING TIMES FOR 8 MHZ)
;NOV./16/1983		; USING SYSCOM.LIB
;NOV/16/83
;11-17-1983	; ADD TIMER_INT ENTRY (H/W)
;		; USING EQCOM.LIB
;---------------------------------------
;  CALENDAR BI0
;
;    ENTRY
;
;	 (AH) =	0 : GET	TIME OF	DAY
;
;	 (AH) =	1 : SET	TIME OF	DAY
;
;	      (ES,BX) =	POINTER	TO DATA	BUFFER
;
;
;---------------------------------------
;****************************************
;*	EQUATE TABLE			*
;*********                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 VECTOR		*
;****************************************
INT_VEC		SEGMENT	AT 0000H
TIME_VEC	EQU	7
		ORG	TIME_VEC*4
USER_OFS	LABEL	WORD
		ORG	$+2
USER_SEG	LABEL	WORD
INT_VEC		ENDS
;****************************************
;*	USER PARAMETER SEGMENT		*
;*		This is dummy segment	*
;*		for assemble		*
;****************************************
USER		SEGMENT	AT 0060H
USER		ENDS
;****************************************
;*	C-MOS SEGMENT			*
;****************************************
CMOS		SEGMENT	AT 0A3FEH
		ORG	7*4+2
YY_OFST		LABEL	BYTE
CMOS		ENDS
;
INCLUDE		B:EQCOM.LIB	;---- 11-17-1983 (A)
INCLUDE		B:SYSCOM.LIB
;
		PAGE
ROM 	SEGMENT		WORD	PUBLIC
	ASSUME	CS:ROM ,DS:SYSCOM,ES:USER,SS:USER
	PUBLIC		TIMER_IO	; ROM       ENTRY
	PUBLIC		TIMER_INT	; H/W INT. --- 11-17-1983 (A)
;******ENTRY
;
TIMER_IO:
	PUSH	DS		;SAVE ENVIRONMENT
	PUSH	SI
	PUSH	BP
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	SI,SEG SYSCOM
	MOV	DS,SI		; SET ZERO TO DS
	OR	AH,AH		;GET TIME OF DAY (AH=0)
	JZ	CA_GET_TIME	;JUMP IF SO
	DEC	AH		;SET TIME OF DAY (AH=1)
	JZ	CA_SET_TIME	;JUMP IF SO
	DEC	AH		;SET INTERVAL TIMER FOR	EXTERNAL (AH=2)
	JZ	CA_EX_INTVL	;JUMP IF SO
	DEC	AH		;SET INTERVAL TIMER FOR	INTERNAL (AH=3)
	JZ	CA_IN_INTVL	;JUMP IF SO
CA_RESUME:			;RESET ENVIRONMENT
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	BP
	POP	SI
	POP	DS
	IRET
	PAGE
;------------------------
;
;GET TIME OF DAY
;
;------------------------

CA_GET_TIME:
	STI			;IF:=1
;
;******TIME READ COMMAND
;
	MOV	AL,TMR_CMD
	CALL	CA_CMD_SET1
;
;******REGISTER	SHIFT COMMAND
;
	MOV	AL,RGS_CMD
	CALL	CA_CMD_SET
	ADD	BX,4		;POINT MINUTE/SECOND FIELD
	MOV	SI,2
CA_GET_T00:
	MOV	DL,16
CA_GET_T10:
;
;******READ TIME
;
	MOV	CX,0CH		;SET LOOPING TIMES FOR 5MHZ
	TEST	BYTE PTR [BIOS_FLAG+1],80H	; CHECK 8/5 Mhz NOV/16/83
	JZ 	CA_GET_T15	;SKIP IF CLOCK=5MHZ
	MOV	CX,11H		;SET LOOPING TIMES FOR 8MHZ
CA_GET_T15:
	IN	AL,PORTB	;READ DATA OF CALENDAR
	SHR	AL,1		;CF:=DATA
	RCR	BP,1		;BP:=DATA(CF)
	MOV	AL,11H
	NOP				;83.09.07
	OUT	CALEND,AL	;CLK:=1
;
;******WAIT  40 MICRO SEC HERE
;
CA_GET_T20:
	LOOP	CA_GET_T20
	MOV	AL,01H
	OUT	CALEND,AL	;CLK:=0
	DEC	DL
	JNZ	CA_GET_T10
	DEC	SI
	JS	CA_GET_T30
	MOV	CL,8
	ROR	BP,CL		;EXGHANG L/H
	MOV	ES: [BX],BP
	SUB	BX,2
	OR	SI,SI
	JNZ	CA_GET_T00
	MOV	DL,8
	JMP 	SHORT	CA_GET_T10
;
;******SET YEAR
;
CA_GET_T30:
	INC	BX		;ADJUST	POINTER
	MOV	AX,BP
	MOV	ES:[BX],AH
	MOV	AX,SEG CMOS
	MOV	DS,AX		;SET CMOS SEGMENT ADDR
	ASSUME	DS:CMOS
	MOV	AH,[YY_OFST]		;----------------------NOV/16/83---
	DEC	BX
	MOV	ES:[BX],AH	;SET YY_DATA TO	DATA_BUFF
	JMP	CA_RESUME	;GO TO RESUME
	PAGE
;
;******CONVERT SHORT_JMP TO LONG_JMP
;
	ASSUME	DS:SYSCOM
CA_EX_INTVL:
	JMP	CA_INTERVAL
CA_IN_INTVL:
	JMP	CA_INTERVAL1
;------------------------
;
;SET TIME OF DAY
;
;------------------------

CA_SET_TIME:
	STI			;IF:=1
;
;******REGISTER	SHIFT COMMAND
;
	MOV	AL,RGS_CMD
	CALL	CA_CMD_SET
	ADD	BX,4		;POINT MIN/SEC FIELD
	MOV	SI,2		;SET CNT #0
CA_SET_T00:
	MOV	DL,16
CA_SET_T10:
	MOV	BP,ES:[BX] ;GET DATA FROM BUFFER
	MOV	CL,8
	ROR	BP,CL		;EXCHANGE L/H
CA_SET_T20:
	CLC			;CF:=0
	SHR	BP,1		;CF:=DATA
	JB	CA_SET_T30	;JMP IF	CARRY ON
;
;******WRITE CALENDAR
;
	MOV	AL,01H
	OUT	CALEND,AL	;SET DI
	MOV	AL,11H
	NOP					;83.09.07
	OUT	CALEND,AL	;CLK=1
	MOV	AL,01H
	OUT	CALEND,AL	;CLK=0
	JMP 	SHORT	CA_SET_T40
CA_SET_T30:
	MOV	AL,21H		;SET DI
	OUT	CALEND,AL
	MOV	AL,31H
	NOP					;83.09.07
	OUT	CALEND,AL	;CLK=1
	MOV	AL,21H
	OUT	CALEND,AL	;CLK=0
CA_SET_T40:
	DEC	DL
	JNZ	CA_SET_T20
	SUB	BX,2
	DEC	SI
	JS	CA_SET_T50
	OR	SI,SI
	JNZ	CA_SET_T00
	MOV	DL,8
	JMP     SHORT	CA_SET_T10
CA_SET_T50:
	ADD	BX,2
	MOV	AH,ES:[BX]	;GET YY_DATA FROM DATA_BUFF
	MOV	CX,SEG CMOS		;------------------NOV/16/83--
	MOV	DS,CX		;SET CMOS_SEG_ADDR TO DS
	ASSUME	DS:CMOS
	MOV	AL,0DH		;NBMW PERMIT
	OUT	68H,AL
	MOV	[YY_OFST],AH
	MOV	AL,0CH		;INHIBIT
	OUT	68H,AL
	MOV	AX,SEG SYSCOM
	MOV	DS,AX		; SET ZERO TO DS
	ASSUME	DS:SYSCOM
;
;******TIME SET	& COUNTER HOLD
;
	MOV	AL,TMS_CMD
	CALL	CA_CMD_SET
;
;******REGISTER	HOLD
;
	MOV	AL,RGH_CMD
	CALL	CA_CMD_SET
	JMP	CA_RESUME	;GO TO RESUME
;
	PAGE
;------------------------
;
;COMMAND SET SUB ROUTINE
;
;------------------------
CA_CMD_SET:
	MOV	CX,0CH		;SET LOOPING TIMES FOR 5MHZ
	TEST	BYTE PTR [BIOS_FLAG+1],80H    ; CHECK 8/5 MHZ
	JZ 	CA_CMD_SET2 	;SKIP IF CLOCK=5MHZ
	MOV	CX,11H		;SET LOOPING TIMES FOR 8MHZ
	JMP	SHORT 	CA_CMD_SET2
CA_CMD_SET1:
	MOV	CX,10H		;SET LOOPING TIMES FOR 5MHZ
	TEST	BYTE PTR [BIOS_FLAG+1],80H	; CHECK 8/5 MHZ
	JZ 	CA_CMD_SET2	;SKIP IF CLOCK=5MHZ
	MOV	CX,17H		;SET LOOPING TIMES FOR 8MHZ
CA_CMD_SET2:
	OUT	CALEND,AL
	OR	AL,08H
	NOP					;83.09.07
	OUT	CALEND,AL	;STB=1
CA_CMD_SET3:
	LOOP	CA_CMD_SET3
	AND	AL,0F7H
	OUT	CALEND,AL	;STB=0
	RET
	PAGE
;------------------------------------
;	SET INTERVAL TIMER
;
;	ENTRY
;
;           (AH) = 2 : SET INTERVAL TIMER FROM UPPER ROUTINE
;
;	    (AH) = 3 : SET INTERVAL TIMER FROM CALENDAR BIO
;
;		CX   = INTERVAL TIME VALUE FROM 10 MMSEC TO 655360 MM SEC
;
;------------------------------------

;
;******ENTRY FROM TIMER_MANAGEMENT ROUTINE
;
CA_INTERVAL1:
	JMP 	CA_INT_CMN
;
;******ENTRY FROM UPPER	ROUTINE
;
CA_INTERVAL:
	MOV	CA_TIM_CNT,CX	;SAVE TIME

	PUSH	DS
;----------------------------------CHG NOV/16/83---------------
	MOV	AX,SEG INT_VEC
	MOV	DS,AX
	ASSUME	DS:INT_VEC
	MOV	[USER_OFS],BX
	MOV	[USER_SEG],ES
	POP	DS
	ASSUME	DS:SYSCOM
;---------------------------------------------------------------
;
;******SET INTERVAL TIMER CONTROL WORD
;
	MOV	AL,CTL_CMD
	OUT	TIM_CTL,AL
CA_INT_CMN:
;
;******SET COUNTER_VALUE 10 MM SEC
;
	TEST	BYTE PTR [BIOS_FLAG+1],80H   ; CHECK 8/5MHZ
	JNZ	CA_INT_C5	;SKIP IF CLOCK=8MHZ
	MOV	AL,00H
	OUT	TIMER0,AL	;SET LSB
	MOV	AL,60H
	OUT	TIMER0,AL	;SET MSB
	JMP 	CA_INT_C10
CA_INT_C5:
	MOV	AL,00H
	OUT	TIMER0,AL	;SET LSB
	MOV	AL,4EH
	OUT	TIMER0,AL	;SET MSB
CA_INT_C10:
;
;******MAKE TIMER ENABLE
;
	NOP  
	NOP			;--- 11-17-1983 (A)
;----------- THIS NOP EXISTED IN X1 ROM ----------------------
	IN	AL,INTM_O1	;GET TMR
	AND	AL,0FEH		;RESET TIMER_MASK_BIT
	OUT	INTM_O1,AL
	JMP	CA_RESUME
;
;
;-------------- FROM HERE TO THE END, ADDED 11-17-1983 TO
;		PROVIDE H/W INTERRUPT ENTRY.
;
	PAGE
;------------------------
;THIS ROUTINE WILL BE CALLED,
;WHEN A	HARD_WARE INTERRUPT OCCURRS.
;
;------------------------
TIMER_INT:	;---- CHANGED 11-17-1983
	STI			;ENABLE INTERRUPT
	PUSH	AX		;SAVE ENVIRONMENT
	PUSH	DS
	XOR	AX,AX  
	MOV	DS,AX		;TO ACCESS SYSTEM COMMON AREA
	DEC	CA_TIM_CNT
	JZ	CA_INT_M10
	POP	DS
;
;******EOI
;
	MOV	AL,EOI
	OUT	INTM_O2,AL
	MOV	AH,3
	INT	1CH		;CALL SET INTERVAL TIMER
	POP	AX
	IRET
;---------
;TIME OUT
;---------
;
;******EOI
;
CA_INT_M10:
	IN	AL,INTM_O1	;READ IMR
	OR	AL,01H		;MASK TIMER INTERRUPT
	OUT	INTM_O1,AL	;DISABLE TIMER

	MOV	AL,EOI
	OUT	INTM_O2,AL
;
;******CALL CALLER_INT_PROCEDURE ROUTINE
;
	POP	DS
	POP	AX
	INT	07H		;CALL UPPER INTERRUPT ROUTINE
	IRET

;
ROM 	ENDS
	END
	

