                PAGE    58,132
                TITLE   GRAPHROM
                .LFCOND
;*********************************************************************
;*
;*      GRAPHROM
;*
;*
;*
;*
;*
;*
;*********************************************************************
;
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      CONSTANT
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;
;       GDC PORT & COMMAND
;
GRAPH_GDC_COM           EQU     0A2H
GRAPH_GDC_PAR           EQU     0A0H
;
START                   EQU     0DH
STOP                    EQU     0CH
ZOOM			EQU	46H
VECTW                   EQU     4CH
VECTE                   EQU     6CH
TEXTW                   EQU     78H
TEXTE                   EQU     68H
CSRW                    EQU     49H
MASKC                   EQU     4AH
WRITE                   EQU     20H
;
;       SYSTEM PORT
;
ACCESS_BANK             EQU     0A6H
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      MACRO
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
GDC_FIFO_EMPTY          MACRO
                        LOCAL   L
L:
                        IN      AL,GRAPH_GDC_PAR
                        TEST    AL,4
                        JZ      L
                        ENDM
;
GDC_FIFO_EMPTY_VSYNC    MACRO
                        LOCAL   L
L:
                        IN      AL,GRAPH_GDC_PAR
                        XOR     AL,24H
                        TEST    AL,24H
                        JNZ     L
                        ENDM
;
GDC_FIFO_NOT_FULL       MACRO
                        LOCAL   L
L:
                        IN      AL,GRAPH_GDC_PAR
                        TEST    AL,2
                        JNZ     L
                        ENDM
;
GDC_NOT_DRAWING         MACRO
                        LOCAL   L
L:
                        IN      AL,GRAPH_GDC_PAR
                        TEST    AL,8
                        JNZ     L
                        ENDM
;
OUTCOM                  MACRO   COM
                        MOV     AL,COM
                        OUT     GRAPH_GDC_COM,AL
                        ENDM
;
OUTPAR                  MACRO   PAR
                        MOV     AL,PAR
                        OUT     GRAPH_GDC_PAR,AL
                        ENDM
;
OUTCOMN                 MACRO   COM
			NOP
                        NOP
                        OUTCOM  COM
                        ENDM
;
OUTPARN                 MACRO   PAR
			NOP
                        NOP
                        OUTPAR  PAR
                        ENDM
;
OUTCOMW                 MACRO   COM
                        GDC_FIFO_NOT_FULL
                        OUTCOM  COM
                        ENDM
;
OUTPARW         	MACRO   PAR
                        GDC_FIFO_NOT_FULL
                        OUTPAR	PAR
                        ENDM
;
OUTCOMNW		MACRO	COM
			NOP
			NOP
			NOP
			NOP
			OUTCOMW	COM
			ENDM
;
OUTPARNW		MACRO	PAR
			NOP
			NOP
			NOP
			NOP
			OUTPARW	PAR
			ENDM
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      DATA AREA
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
INCLUDE         B:SYSCOM.LIB
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+
;+      CODE AREA
;+
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
ROM             SEGMENT PUBLIC
                ASSUME  CS:ROM,DS:SYSCOM,ES:SYSCOM
;
;
                PUBLIC  CLS
                PUBLIC  LINE
                PUBLIC  BOX
                PUBLIC  BOX_FILL
                PUBLIC  CIRCLE
;
;
;
;*********************************************************************
;*
;*      CNV_GDC_ADDRESS
;*
;*              CALCULATE EAD/dAD
;*
;*
;*              IN:  (CX,DX) = (X,Y)
;*
;*              OUT: DI = EAD
;*
;*                   CL = dAD * 16
;*
;*              DESTORY: DX
;*
;*********************************************************************
;
CNV_GDC_ADDRESS PROC
                MOV     DI,CX
                SHR     DI,1
                SHR     DI,1
                SHR     DI,1
                SHR     DI,1            ; DI = X / 16
                SHL     DX,1
                SHL     DX,1
                SHL     DX,1
                ADD     DI,DX           ; ADD ( Y * 8 )
                SHL     DX,1
                SHL     DX,1
                ADD     DI,DX           ; ADD ( Y * 32 )
                ADD     DI,4000H        ; DI = (Y*40)+(X/16)+4000H
                SHL     CL,1
                SHL     CL,1
                SHL     CL,1
                SHL     CL,1            ; CL = (X MOD 16) * 16
                RET
CNV_GDC_ADDRESS ENDP
;
;*********************************************************************
;*
;*      SEND_GDC
;*
;*              SEND COMMANDS TO GRAPHIC GDC
;*
;*
;*              IN:  CS:BX = COMMAND BLOCK POINTER
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL,BX,CX,DX
;*
;*********************************************************************
;
SEND_GDC        PROC
                XOR     CH,CH
                XOR     DH,DH
                MOV     CL,CS:[BX]      ; GET NUMBER OF COMMANDS
SG1:
                INC     BX
                MOV     DL,CS:[BX]      ; GET PORT NUMBER
                INC     BX
                MOV     AL,CS:[BX]      ; GET DATA
                OUT     DX,AL
                LOOP    SG1
                RET
SEND_GDC        ENDP
;
;*********************************************************************
;*
;*      SET_ACCESS_BANK
;*
;*              SET ACCESS BANK IF NECESSARY
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL
;*
;*********************************************************************
;
SET_ACCESS_BANK PROC
                MOV     AL,DRAW_PAGE_SETTING
                CMP     AL,DRAW_PAGE
                JNZ     SET_ACCESS_BANK1
                RET
SET_ACCESS_BANK ENDP
;
;*********************************************************************
;*
;*      SET_ACCESS_BANK1
;*
;*              SET ACCESS BANK
;*
;*
;*              IN:  AL = BANK NUMBER
;*
;*              OUT: NOTHING
;*
;*              DESTROY: NOTHING
;*
;*********************************************************************
;
SET_ACCESS_BANK1 PROC
                MOV     DRAW_PAGE,AL
		OUTCOMW	ZOOM
		NOP
		NOP
		NOP
		NOP
                GDC_FIFO_EMPTY
                MOV     AL,DRAW_PAGE
                OUT     ACCESS_BANK,AL
                RET
SET_ACCESS_BANK1 ENDP
;
;*********************************************************************
;*
;*      CLS
;*
;*              CLEAR SCREEN
;*
;*
;*              IN:  AL = PALETTE NUMBER
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
ALL0FFH         DB      9
                DB      GRAPH_GDC_COM,TEXTW
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
                DB      GRAPH_GDC_PAR,0FFH
CLS             PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                XOR     AH,AH                   ; CLEAR STOP FLAG
                MOV     BP,AX                   ; SAVE PALETTE NUMBER
                MOV     WORD PTR CSRW_P1,4000H  ; SET CURSOR
                MOV     BYTE PTR CSRW_P3,0
                CALL    SET_ACCESS_BANK
                GDC_FIFO_EMPTY
                MOV     BX,OFFSET ALL0FFH
                CALL    SEND_GDC
                MOV     AL,DRAW_PAGE_SETTING
                CMP     AL,ACTIVE_PAGE
                JNZ     CLS1
                OUTCOM  STOP
                OR      BP,0FF00H               ; SET STOP FLAG
CLS1:
                TEST    CRT_COLOR,1
                JNZ     CLS_COLOR
                                                ; B/W MODE
                MOV     AX,BP
                AND     AL,1
                OR      AL,WRITE OR 2           ; SET MOD (CLEAR/SET)
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
                CALL    DRAW_CLS
                JMP     SHORT CLS99
CLS_COLOR:                                      ; COLOR MODE
                MOV     AX,BP
                SHR     AL,1
                SHR     AL,1
                AND     AL,1
                OR      AL,WRITE OR 2           ; SET MOD (CLEAR/SET)
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
                CALL    DRAW_CLS
                ADD     WORD PTR CSRW_P1,4000H
                MOV     AX,BP
                AND     AL,110B
                JZ      CLS2                    ; SAME MOD
                CMP     AL,110B
                JZ      CLS2                    ; SAME MOD
                SHR     AL,1
;               AND     AL,1
                OR      AL,WRITE OR 2           ; SET MOD (CLEAR/SET)
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
CLS2:
                CALL    DRAW_CLS
                ADD     WORD PTR CSRW_P1,4000H
                MOV     AX,BP
                AND     AL,011B
                JZ      CLS3                    ; SAME MOD
                CMP     AL,011B
                JZ      CLS3                    ; SAME MOD
;               AND     AL,1
                OR      AL,WRITE OR 2           ; SET MOD (CLEAR/SET)
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
CLS3:
                CALL    DRAW_CLS
CLS99:
                TEST    BP,0FF00H               ; CHECK STOP FLAG
                JZ      CLS_RET
                GDC_FIFO_EMPTY_VSYNC
                OUTCOM  START
CLS_RET:
                POP     DX
                POP     CX
                POP     BX
                RET
CLS             ENDP
;
;*********************************************************************
;*
;*      DRAW_CLS
;*
;*              SEND COMMAND BLOCK FOR CLS
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL
;*
;*********************************************************************
;
DRAW_CLS        PROC
                GDC_FIFO_EMPTY
                OUTCOM  CSRW
                OUTPAR  CSRW_P1
                OUTPAR  CSRW_P2
                OUTPAR  CSRW_P3
                OUTCOMN MASKC
                OUTPARN 0FFH
                OUTPARN 0FFH
                OUTCOMN VECTW
                OUTPARN 10H                     ; GRAPH CHAR,DIR=0
                OUTPARN 39                      ; DC=39
                OUTPARN 0
                OUTPARN 90H                     ; D=400
                OUTPARN 01H
                OUTCOMN TEXTE
                RET
DRAW_CLS        ENDP
;
;*********************************************************************
;*
;*      LINE
;*
;*              DRAW LINE
;*
;*
;*              IN:  (SI,DI) = (X1,Y1)
;*
;*                   (CX,DX) = (X2,Y2)
;*
;*                   BX = LINE PATTERN
;*
;*                   AL = PALETTE NUMBER (INCLUDE MOD : IF B/W MODE)
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
LINE            PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BP,AX                   ; SAVE PALETTE NUMBER
IF 1 ;--------------------------------------------------------- 03/15/1984 ----
L0:
		PUSH	SI
		PUSH	DI
		MOV	AL,8			; DIR = 0
		SUB	CX,SI			; X2 - X1
		JNC	L2
		ADD	CX,SI
		MOV	AL,0FH			; DIR = 7
		XCHG	CX,SI
		SUB	CX,SI
L2:						; CX = dX
		SUB	DX,DI			; Y2 - Y1
		JNC	L3
		ADD	DX,DI
		XOR	AL,3
		XCHG	DX,DI
		SUB	DX,DI
L3:						; DX = dY
		CMP	CX,DX			; dX - dY
		JC	L5
		JZ	L4
		XOR	AL,1
		JMP	SHORT L51
L4:
		OR	AL,1
L5:
		XCHG	CX,DX
L51:
		AND	CX,CX
		JZ	L6
		AND	DX,DX
		JNZ	L7
L6:
		INC	AL
		AND	AL,0FEH			; MASK LSB
L7:
		MOV	VECTW_P1,AL
		MOV	SI,CX
		MOV	DI,DX
		POP	DX
		POP	CX
ELSE ;----------------------------------------------------------------
                CMP     SI,CX                   ; X1 - X2
                JC      L1                      ; JUMP IF ( X1 < X2 )
                JA      L2                      ; JUMP IF ( X1 > X2 )
L0:
                CMP     DI,DX                   ; Y1 - Y2
                JNC     L2                      ; JUMP IF ( Y1 >= Y2 )
L1:
                XCHG    SI,CX                   ; X1 <=> X2
                XCHG    DI,DX                   ; Y1 <=> Y2
L2:
                SUB     SI,CX                   ; DX = X1 - X2
                SUB     DI,DX                   ; DY = Y2 - Y1
                NEG     DI
                JNS     L3                      ; JUMP IF ( DY >= 0 )
                NEG     DI                      ; DY = !DY!
                CMP     SI,DI                   ; DX - DY
                JC      L4                      ; JUMP IF ( DX < DY )
                MOV     VECTW_P1,09H            ; SET DIR=1
                JMP     SHORT LCOM
L3:
                CMP     DI,SI                   ; DY - DX
                JC      L5                      ; JUMP IF ( DY < DX )
                MOV     VECTW_P1,0BH            ; SET DIR=3
                JMP     SHORT LCOM0
L5:
                MOV     VECTW_P1,0AH            ; SET DIR=2
                JMP     SHORT LCOM
L4:
                MOV     VECTW_P1,08H            ; SET DIR=0
LCOM0:
                XCHG    SI,DI                   ; DX <=> DY
LCOM:
ENDIF ;-----------------------------------------------------------------------
                MOV     WORD PTR VECTW_P2,SI    ; SET DC = DX
                SHL     DI,1
                MOV     WORD PTR VECTW_P8,DI    ; SET D1 = 2*DY
                SUB     DI,SI
                MOV     WORD PTR VECTW_P4,DI    ; SET D = D1-DX
                SUB     DI,SI
                MOV     WORD PTR VECTW_P6,DI    ; SET D2 = D-DX
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1,DI
                MOV     BYTE PTR CSRW_P3,CL
                CALL    SET_ACCESS_BANK
                GDC_FIFO_EMPTY
                TEST    CRT_COLOR,1
                JNZ     LINE_COLOR
                                                ; B/W MODE
                MOV     AX,BP
                ROL     AL,1
                ROL     AL,1
                AND     AL,11B                  ; GET MOD
                OR      AL,WRITE
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
                TEST    BP,1
                JNZ     LD1
                NOT     BX
LD1:
                OUTCOM  TEXTW
                OUTPARN BL
                OUTPARN BH
                CALL    DRAW_LINE
                JMP     LINE99
LINE_COLOR:                                     ; COLOR MODE
		OUTCOM	TEXTW
		OUTPARN	BL
		OUTPARN	BH
                TEST    BP,100B
		MOV	BL,WRITE OR 10B		; SET MOD
                JZ	LD2
                XOR     BL,1
LD2:
                OUTCOM  BL			; SEND WRITE COMMAND (MOD)
                CALL    DRAW_LINE
                ADD     WORD PTR CSRW_P1,4000H
                MOV     AX,BP
                AND     AL,110B
                JZ      LD3                     ; SAME PATTERN
                CMP     AL,110B
                JZ      L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                D
LD4:
                CALL    DRAW_LINE
LINE99:
                POP     DX
                POP     CX
                POP     BX
                RET
LINE            ENDP
;
;*********************************************************************
;*
;*      DRAW_LINE
;*
;*              SEND COMMAND BLOCK FOR LINE
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL
;*
;*********************************************************************
;
DRAW_LINE       PROC
                GDC_FIFO_EMPTY
                OUTCOM  CSRW
                OUTPAR  CSRW_P1
                OUTPAR  CSRW_P2
                OUTPAR  CSRW_P3
                OUTCOMN VECTW
                OUTPAR  VECTW_P1
                OUTPAR  VECTW_P2
                OUTPAR  VECTW_P3
                OUTPAR  VECTW_P4
                OUTPAR  VECTW_P5
                OUTPAR  VECTW_P6
                OUTPAR  VECTW_P7
                OUTPAR  VECTW_P8
                OUTPAR  VECTW_P9
                OUTCOMN VECTE
                RET
DRAW_LINE       ENDP
;
;*********************************************************************
;*
;*      BOX
;*
;*              DRAW BOX
;*
;*
;*              IN:  (SI,DI) = (X1,Y1)
;*
;*                   (CX,DX) = (X2,Y2)
;*
;*                   BX = LINE PATTERN
;*
;*                   AL = PALETTE NUMBER (INCLUDE MOD : IF B/W MODE)
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
BOX             PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BP,AX                   ; SAVE PALETTE NUMBER
                CMP     SI,CX                   ; X1 - X2
                JC      B1                      ; JUMP IF ( X1 < X2 )
                JA      B2                      ; JUMP IF ( X1 > X2 )
                JMP     L0                      ; DRAW LINE
L_BOOT:
		ADD	SI,CX
		MOV	DI,DX
                JMP     L0                      ; DRAW LINE
B1:
                XCHG    SI,CX                   ; X1 <=> X2
                XCHG    DI,DX                   ; Y1 <=> Y2
B2:
                SUB     SI,CX                   ; DX = X1 - X2
                SUB     DI,DX                   ; DY = Y2 - Y1
                NEG     DI
                JZ      L_BOOT
                MOV     AL,42H                  ; SET DIR=2
                JNS     B3                      ; JUMP IF ( DY >= 0 )
                NEG     DI                      ; DY = !DY!
                MOV     AL,40H                  ; SET DIR=0
                XCHG    SI,DI                   ; DX <=> DY
B3:
                MOV     BYTE PTR VECTW_P1,AL
                MOV     WORD PTR VECTW_P2,3     ; SET DC = 3
                MOV     WORD PTR VECTW_P4,SI    ; SET D = DX
                MOV     WORD PTR VECTW_P6,DI    ; SET D2 = DY
                MOV     WORD PTR VECTW_P8,0FFFFH; SET D1 = -1
                MOV     WORD PTR VECTW_P10,SI   ; SET DM = DX
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1,DI
                MOV     BYTE PTR CSRW_P3,CL
                CALL    SET_ACCESS_BANK
                GDC_FIFO_EMPTY
                TEST    CRT_COLOR,1
                JNZ     BOX_COLOR
                                                ; B/W MODE
                MOV     AX,BP
                ROL     AL,1
                ROL     AL,1
                AND     AL,11B                  ; GET MOD
                OR      AL,WRITE
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
                TEST    BP,1
                JNZ     BD1
                NOT     BX
BD1:
                OUTCOM  TEXTW
                OUTPARN BL
                OUTPARN BH
                CALL    DRAW_BOX
                JMP     BOX99
BOX_COLOR:                                      ; COLOR MODE
		OUTCOM	TEXTW
		OUTPARN	BL
		OUTPARN	BH
                TEST    BP,100B
		MOV	BL,WRITE OR 10B		; SET MOD
                JZ	BD2
                XOR     BL,1
BD2:
                OUTCOM	BL			; SEND WRITE COMMAND
                CALL    DRAW_BOX
                ADD     WORD PTR CSRW_P1,4000H
                MOV     AX,BP
                AND     AL,110B
                JZ      BD3                     ; SAME PATTERN
                CMP     AL,110B
                JZ      BD3                     ; SAME PATTERN
                XOR     BL,1
                OUTCOMW	BL			; SEND WRITE COMMAND
BD3:
                CALL    DRAW_BOX
                ADD     WORD PTR CSRW_P1,4000H
                MOV     AX,BP
                AND     AL,011B
                JZ      BD4                     ; SAME PATTERN
                CMP     AL,011B
                JZ      BD4                     ; SAME PATTERN
                XOR     BL,1
                OUTCOMW	BL			; SEND WRITE COMMAND
BD4:
                CALL    DRAW_BOX
BOX99:
                POP     DX
                POP     CX
                POP     BX
                RET
BOX             ENDP
;
;*********************************************************************
;*
;*      DRAW_BOX
;*
;*              SEND COMMAND BLOCK FOR BOX
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL
;*
;*********************************************************************
;
DRAW_BOX        PROC
                GDC_FIFO_EMPTY
                OUTCOM  CSRW
                OUTPAR  CSRW_P1
                OUTPAR  CSRW_P2
                OUTPAR  CSRW_P3
                OUTCOMN VECTW
                OUTPAR  VECTW_P1
                OUTPAR  VECTW_P2
                OUTPAR  VECTW_P3
                OUTPAR  VECTW_P4
                OUTPAR  VECTW_P5
                OUTPAR  VECTW_P6
                OUTPAR  VECTW_P7
                OUTPAR  VECTW_P8
                OUTPAR  VECTW_P9
                OUTPAR  VECTW_P10
                OUTPAR  VECTW_P11
                OUTCOMNW VECTE
                RET
DRAW_BOX        ENDP
;
;*********************************************************************
;*
;*      BOX_FILL
;*
;*              FILL TILING PATTERN IN BOX
;*
;*
;*              IN:  (SI,DI) = (X1,Y1)
;*
;*                   (CX,DX) = (X2,Y2)
;*
;*                   (STACK SEC.):BX = ADDRESS OF TILING PATTERN
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
BOX_FILL        PROC
                MOV     BP,SP
                MOV     ES,SS:[BP+2]
                PUSH    BX
                PUSH    CX
                PUSH    DX
                CMP     SI,CX                   ; X1 - X2
                JNC     BF1
                XCHG    SI,CX
BF1:
                SUB     SI,CX                   ; DX = !X1-X2!
                                                ; SAVE MIN(X1,X2) TO CX REG.
                CMP     DI,DX                   ; Y1 - Y2
                JNC     BF2
                XCHG    DI,DX
BF2:
                MOV     AX,DI
                SUB     DI,DX                   ; DY = !Y1-Y2!
                MOV     DX,AX                   ; SAVE MAX(Y1,Y2)
                DEC     DI
                MOV     BYTE PTR VECTW_P1,12H   ; SET DIR = 2
                MOV     WORD PTR VECTW_P2,DI    ; SET DC = DY-1
                MOV     WORD PTR VECTW_P4,SI    ; SET D = DX
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1,DI
                MOV     BYTE PTR CSRW_P3,CL
                CALL    SET_ACCESS_BANK
                OUTCOMW WRITE                   ; SET MOD = REPLACE
                TEST    CRT_COLOR,1
                JNZ     BOX_FILL_COLOR
                                                ; B/W MODE
                CALL    DRAW_BOX_FILL
                JMP     SHORT BOX_FILL99
BOX_FILL_COLOR:                                 ; COLOR MODE
                ADD     BX,16
                CALL    DRAW_BOX_FILL
                ADD     WORD PTR CSRW_P1,4000H
                SUB     BX,8
                CALL    DRAW_BOX_FILL
                ADD     WORD PTR CSRW_P1,4000H
                SUB     BX,8
                CALL    DRAW_BOX_FILL
BOX_FILL99:
                POP     DX
                POP     CX
                POP     BX
                RET
BOX_FILL        ENDP
;
;*********************************************************************
;*
;*      DRAW_BOX_FILL
;*
;*              SEND COMMAND BLOCK FOR BOX_FILL
;*
;*
;*              IN:  ES:BX = ADDRESS OF TEXTW PARAMETER
;*
;*              OUT: NOTHING
;*
;*              DESTORY: AL
;*
;*********************************************************************
;
DRAW_BOX_FILL   PROC
                GDC_FIFO_EMPTY
                OUTCOM  TEXTW
                OUTPAR  ES:[BX]
                OUTPAR  ES:[BX+1]
                OUTPAR  ES:[BX+2]
                OUTPAR  ES:[BX+3]
                OUTPAR  ES:[BX+4]
                OUTPAR  ES:[BX+5]
                OUTPAR  ES:[BX+6]
                OUTPAR  ES:[BX+7]
                OUTCOMN CSRW
                OUTPAR  CSRW_P1
                OUTPAR  CSRW_P2
                OUTPAR  CSRW_P3
                OUTCOMN VECTW
                OUTPAR  VECTW_P1
                OUTPAR  VECTW_P2
                OUTPARNW VECTW_P3
                OUTPARNW VECTW_P4
                OUTPARNW VECTW_P5
                OUTCOMNW TEXTE
                RET
DRAW_BOX_FILL   ENDP
;
;*********************************************************************
;*
;*      CIRCLE
;*
;*              DRAW CIRCLE
;*
;*
;*              IN:  (CX,DX) = CENTER POINT
;*
;*                   SI = RADIUS
;*
;*                   BX = LINE PATTERN
;*
;*                   AL = PALETTE NUMBER (INCLUDE MOD : IF B/W MODE)
;*
;*              OUT: NOTHING
;*
;*********************************************************************
;
CIRCLE          PROC
                PUSH    BX
                PUSH    CX
                PUSH    DX
                MOV     BP,AX                   ; SAVE PALETTE NUMBER
                PUSH    BX                      ; SAVE LINE PATTERN
                MOV     AX,CX
                MOV     BX,DX
                SUB     DX,SI
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1,DI
                MOV     BYTE PTR CSRW_P3,CL
                MOV     CX,AX
                MOV     DX,BX
                SUB     CX,SI
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1_1,DI
                MOV     BYTE PTR CSRW_P3_1,CL
                MOV     CX,AX
                MOV     DX,BX
                ADD     DX,SI
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1_2,DI
                MOV     BYTE PTR CSRW_P3_2,CL
                MOV     CX,AX
                MOV     DX,BX
                ADD     CX,SI
                CALL    CNV_GDC_ADDRESS
                MOV     WORD PTR CSRW_P1_3,DI
                MOV     BYTE PTR CSRW_P3_3,CL
                MOV     BYTE PTR VECTW_P1,21H   ; SET DIR=1
                MOV     AX,0B504H
                MUL     SI
		INC	DX
                MOV     WORD PTR VECTW_P2,DX    ; SET DC= RADIUS / 1.4142
                DEC     SI
                MOV     WORD PTR VECTW_P4,SI    ; SET D= RADIUS - 1
                SHL     SI,1
                MOV     WORD PTR VECTW_P6,SI    ; SET D2= 2 * (RADIUS - 1)
                MOV     WORD PTR VECTW_P8,0FFFFH; SET D1= -1
                MOV     WORD PTR VECTW_P10,0    ; SET DM= 0
                CALL    SET_ACCESS_BANK
                GDC_FIFO_EMPTY
                POP     BX                      ; RESTORE LINE PATTERN
                TEST    CRT_COLOR,1
                JNZ     CIRCLE_COLOR
                                                ; B/W MODE
                MOV     AX,BP
                ROL     AL,1
                ROL     AL,1
                AND     AL,11B                  ; GET MOD
                OR      AL,WRITE
                OUT     GRAPH_GDC_COM,AL        ; SEND WRITE COMMAND
                TEST    BP,1
                JNZ     CD1
                NOT     BX
CD1:
                OUTCOM  TEXTW
                OUTPARN BL
                OUTPARN BH
                CALL    DRAW_CIRCLE
                JMP     CIRCLE99
CIRCLE_COLOR:                                   ; COLOR MODE
		OUTCOM	TEXTW
		OUTPARN	BL
		OUTPARN	BH
                TEST    BP,100B
		MOV	BL,WRITE OR 10B		; SET MOD
                JZ	CD2
                XOR     BL,1
CD2:
                OUTCOM	BL			; SEND WRITE COMMAND
                CALL    DRAW_CIRCLE
                ADD     WORD PTR CSRW_P1,4000H
                ADD     WORD PTR CSRW_P1_1,4000H
                ADD     WORD PTR CSRW_P1_2,4000H
                ADD     WORD PTR CSRW_P1_3,4000H
                MOV     AX,BP
                AND     AL,110B
                JZ      CD3                     ; SAVE PATTERN
                CMP     AL,110B
                JZ      CD3                     ; SAME PATTERN
                XOR     BL,1
                OUTCOMW	BL			; SEND WRITE COMMAND
CD3:
                CALL    DRAW_CIRCLE
                ADD     WORD PTR CSRW_P1,4000H
                ADD     WORD PTR CSRW_P1_1,4000H
                ADD     WORD PTR CSRW_P1_2,4000H
                ADD     WORD PTR CSRW_P1_3,4000H
                MOV     AX,BP
                AND     AL,011B
                JZ      CD4                     ; SAME PATTERN
                CMP     AL,011B
                JZ      CD4                     ; SAME PATTERN
                XOR     BL,1
                OUTCOMW	BL			; SEND WRITE COMMAND
CD4:
                CALL    DRAW_CIRCLE
CIRCLE99:
                POP     DX
                POP     CX
                POP     BX
                RET
CIRCLE          ENDP
;
;*********************************************************************
;*
;*      DRAW_CIRCLE
;*
;*              SEND COMMAND BLOCK FOR CIRCLE
;*
;*
;*              IN:  NOTHING
;*
;*              OUT: NOTHING
;*
;*              DESTROY: AL,SI
;*
;*********************************************************************
;
DRAW_CIRCLE     PROC
                MOV     SI,OFFSET CSRW_P1
DCLP1:
                CALL	DRAW_ARC
                MOV     AL,BYTE PTR VECTW_P1
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ***
;
DRAW_ARC        PROC
                GDC_FIFO_EMPTY
                OUTCOM  CSRW
                OUTPAR  DS:[SI]
                OUTPAR  DS:[SI+1]
                OUTPAR  DS:[SI+2]
                OUTCOMN VECTW
                OUTPAR  VECTW_P1
                OUTPAR  VECTW_P2
                OUTPAR  VECTW_P3
                OUTPAR  VECTW_P4
                OUTPAR  VECTW_P5
                OUTPAR  VECTW_P6
                OUTPAR  VECTW_P7
                OUTPAR  VECTW_P8
                OUTPAR  VECTW_P9
                OUTPAR  VECTW_P10
                OUTPAR  VECTW_P11
                OUTCOMNW VECTE
                RET
DRAW_ARC        ENDP
ROM             ENDS
                END
