	PAGE	60,132
	TITLE 	RESTORE FOR A1 MS-DOS Ver 2.0
;************************************************
;*						*
;*	RESTORE COMMAND UTILITY			*
;*						*
;*	       RESTORE BACKUP FILES FROM BACKUP *
;*		DISKETTES TO HARD DISK		*
;*						*
;*						*
;*						*
;************************************************
;
; JUN./15/1984	Final version for the first user release on APC III.
;
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,SS:CODE,ES:CODE
;****************
;*   CONSTANT	*
;****************
;FUNCTION CALL
CON_OUT		EQU  02H	; CONSOLE OUTPUT
CON_INP		EQU  0C01H 	; FLUSH BUFFER,READ KEYBOARD AND ECHO
CON_CHK		EQU  0C08H	; FLUSH BUFFER,READ KEYBOARD
GET_DEF		EQU  19H	; GET DEFAULT DRIVE NO
SET_DTA		EQU  1AH	; SET DTA
MK_DIR		EQU  39H	; CREATE SUB DIRECTORY
RM_DIR		EQU  3AH	; REMOVE DIRECTORY
CH_DIR		EQU  3BH	; CHANGE THE CURRENT DIRECTORY
FL_CREAT	EQU  3CH	; CREATE FILE
FL_OPEN		EQU  3DH	; OPEN A FILE
FL_CLOSE	EQU  3EH	; CLOSE A FILE HANDLE
FL_READ		EQU  3FH	; READ FROM FILE/DEVICE
FL_WRITE	EQU  40H	; WRITE TO A FILE/DEVICE
DEL_FILE	EQU  41H	; DELETE DIRECTORY ENTRY
CH_MODE		EQU  43H	; CHANGE ATTRIBUTE
GET_CUR		EQU  47H	; RETURN TEXT OF CURRENT DIRECTORY
MEM_ALLOC	EQU  48H	; ALLOCATE MEMORY
SETBLOCK	EQU  4AH	; SET BLOCK
PROC_TERM	EQU  4CH	; PROCESS TERMINATE
SEARCH_FIRST	EQU  4EH	; FIND MATCH FILE
SEARCH_NEXT	EQU  4FH	; STEP THROUGH A DIRECTORY MATCHING FILES
FILE_TIME_DATE	EQU  57H	; GET/SET DATE/TIME OF FILE
;
BDOS		EQU  21H	; BDOS CALL
;
BEGIN		EQU  $
	ORG	     100H
START:
	JMP	     RESTORE_EXECUTE
;****************
;*   DATA AREA	*
;****************
;
DEF_DRV_NO	DB   0		; DEFAULT DRIVE NO
ALL_RS_FLAG	DB   0		; ALL FILE RESTORE FLAG
				;   01H = SPECIFIED FILE NAME
				;   00H = NO SPECIFIED FILE NAME
SOURCE		DB   0		; SOURCE DRIVE NO
DEST		DB   0		; DESTINATION DRIVE NO
;
WTLNG		DW   0		; WRITE LENGTA
VOLUME_NO	DW   0		; EXEC VOLUME NO
MULTI_VOL_NO	DW   0		; MULTI VOLUME NO	
MULTI_VOL_FL	DB   0		; MULTI VOLUME FLAG
				;   00H = SINGLE VOLUME
				;   01H = MULTI VOLUME AND NO END VOLUME
				;   FFH = END VOLUME OF MULTI VOLUME
MULTI_VOL_EX	DB   0		; MULTI VOLUME EXEC FLAG
				;   01H = ALREADY SOURCE FILE OPEN
				;   00H = SOURCE FILE NOT OPEN
MULTI_FILE_NO	DB   0		; MULTI VOLUME NO OF FILE
MULTI_FILE_FOUND DB  0		; MULTI VOLUME END FILE FOUND FLAG
				;   00H = END FILE NOT FOUND FOR SEARCH
				;   01H = END FILE JUST FOUND
				;   02H = ALREADY SKIP END FILE COPY
				;   03H = ALL FILE (EXCEPT END FILE) COPY END
WARNING_OUT_FLAG DB  0		; WARNING OUT FLAG
				;   00H = NO WARNING MESSAGE OUT
				;   01H = ALREADY WARNIG MESSAGE OUT
WILD_CARD_FLAG	DB    0		; WILD CARD FLAG
				;   00H = NO SPECIFIED WILD CARD ON FILE NAME
				;   01H = SPECIFIED WILD CARD ON FILE NAME
ROOT_COUNT	DB    0		; ROOT COUNT
DIRECTORY_COUNT	DB    0		; DIRECTORY COUNT
;
BACKUPID_FILE	DB   '@:BACKUPID.@@@',0		; BACKUPID.@@@ FILE PATH NAME
BACKUPID_FNAME	DB   '\BACKUPID.@@@',0		; BACKUPID.@@@ FILE NAME
S_WILD_FILE	DB   '@:*.*',0			; SOURCE DRIVE WILD CARD PATH NAME
D_WILD_FILE	DB   '@:*.*',0			; DESTINATION DRIVE WILD CARD PATH NAME
FILE_WILD:	DB   '\*.*',0			; FILE WILD CARD
SOURCE_PATH	DB   '@:',128 DUP(0)		; SOURCE DRIVE PATH NAME
SOURCE_DIR_PATH	DB   '@:',128 DUP (0)		; SOURCE DRIVE DIRECTORY PATH NAME
SOURCE_FILE_PATH DB  '@:',128 DUP (0)		; SOURCE DRIVE FILE PATH NAME
SOURCE_ROOT_PATH DB  '@:\',0			; SOURCE DRIVE ROOT PATH NAME
SOURCE_PAIR	DB   '@:..',0			; SOURCE DRIVE PARENT BACK PATH NAME
DEST_IN_PATH	DB   '@:',128 DUP (0)		; DESTINATION DRIVE ORIGINAL PATH NAME
DEST_PATH	DB   '@:',128 DUP(0)		; DESTINATION DRIVE PATH NAME
DEST_DIR_PATH	DB   '@:',128 DUP (0)		; DESTINATION DRIVE DIRECTORY PATH NAME
DEST_PAIR	DB   '@:..',0			; DESTINATION DRIVE PARENT BACK PATH NAME
DEST_ROOT_PATH	DB   '@:\',0			; DESTINATION DRIVE ROOT PATH NAME
CUR_DEST_PATH	DB   '@:',128 DUP (0)		; CURRENT DETSTINATION PATH NAME
DIR_MAKE_PATH	DB   '@:',128 DUP (0)		; PATH NAME FOR MAKE DIRECTORY
ENTRY_CHECK_PATH DB  '@:BACKUPID.$$$',0		; ENTRY FULL CHECK PATH
END_FILE_SAVE_AREA DB 14 dup (0) 		; END FILE SAVE AREA
END_PATH_SAVE_AREA DB 128 DUP(0) 		; END PATH SAVE AREA
;
BACKUPID_HAND	DW   0		; BACKUPID.@@@ FILE HANDLE
SOURCE_HAND	DW   0		; SOURCE FILE HANDLE
DEST_HAND	DW   0		; DESTINATION HANDLE
BACKUPID_BUFF	DB   512 DUP(?)	; BACKUPID.@@@ FILE READ BUFFER
FILE_HEADER	DB   128 DUP(?)	; FILE HEADER READ BUFFER
;
FIND_BUF_RES	DB   21 DUP(?)	; RESERVED
FIND_BUF_ATTR	DB    0 	; ATTRIBUTE FOUND
FIND_BUF_TIME	DW    0		; TIME
FIND_BUF_DATE	DW    0	 	; DATE
FIND_BUF_SIZE_L	DW    0		; LOW (SIZE)
FIND_BUF_SIZE_H	DW    0		; HIGH(SIZE)
FIND_BUF_PNAME	DB   13 DUP(0)	; PACKED NAME
;
FIND_BUF_ATTR_S	DB    0		; FILE ATTR,TIME,DATE SAVE AREA
FIND_BUF_TIME_S	DW    0
FIND_BUF_DATE_S	DW    0
;
CUR_FILE_NAME	DB   14 DUP (0)	; CURRENT COPY FILE NAME SAVE AREA
PATH_DISP_AREA	DB   128 DUP (0) ; PATH DISPLAY AREA
FILE_DISP_AREA	DB   13 DUP (0),0DH,0AH,0	; FILE NAME DISPLAY AREA
END_FILE_CHECK_AREA  DB	128 DUP (0)	; END FILE CHECK WORK AREA
RESTORE_BUFFER	DW    0			; RESTORE I/O BUFFER ADDRESS SAVE AREA
INCLUDE	B:REST_MSG.INC
	DB	128 DUP(0)		; STACK AREA
STACKA	EQU	$
include b:rest_prs.inc
	PAGE
;
;--------------- parameter error 
;
PARA_ERROR:
	MOV	SI,OFFSET ERR_MSG_00
	CALL	PMSG			;
	MOV	AL,4			; terminate code 4
	JMP	RESTORE_FIN
;
;--------------- ctrl+c break
;
CTRL_BREAK:
	MOV	AL,3			; terminate code 3
	JMP	RESTORE_FIN		;
;
;--------------- question option
;
quest_exit:
	mov	dx,offset restore_msg
	mov	ah,09h			;
	int	bdos			; display string

	mov	al,0			; terminate code 0
	jmp	restore_fin		;
;
;--------------- RESTORE command main process
;
RESTORE_EXECUTE:
	MOV	SP,OFFSET STACKA
;
	MOV	DX,OFFSET CTRL_BREAK	;
	MOV	AL,23H			; INT 23H CTRL+C BREAK VECTOR
	MOV	AH,25H			; SET VECTOR
	INT	BDOS			;
;
	call	ps			;parse RESTORE command line
	jc	para_error		;
	jnz	quest_exit		; ? option is specified
	mov	ALL_RS_FLAG,01H		; backup all files on
	cmp     filename,0		; specifiled file name?
	jnz	all_bu_off		; filename is specified
	cmp	ext,0			; specified file ext ?
	jz	skip_bu_off		; file ext is not specified
all_bu_off:
	mov	ALL_RS_FLAG,00H		; backup specified  file only
skip_bu_off:
	mov	al,destination_drive	;
	sub	al,"A"			; drive char.-41h
	mov	dest,al
	cmp	destination_drive,0	; specified destination drive ?
	jnz	skip_default		; destination drive is specified
	mov	AH,GET_DEF		; get default drive number
	INT	BDOS			; DEFAULT DRIVE NO GET
	MOV	DEF_DRV_NO,AL		; DEFAULT DRIVE NO SET
	mov	dest,AL			; SET DESTINATION DRIVE NO
skip_default:
	mov	al,source_drive
	sub	al,"A"			; drive char.-41h
	mov	source,al		; set source drive no
	cmp   	al,dest       		; check different drive from source
	je	para_error		;

	mov	di,offset dest_path+2
	cmp	path,0			; specified path ?
	jz	check_file		; path is not specified
	mov	si,offset path
set_dest_path:
	lodsb				; mov al,ptr[si] inc si
	cmp	al,0			; string end ?
	jz	check_file		;
	stosb				; mov ptr[di],al inc di
	jmp	short set_dest_path	;

check_file:
	cmp	filename,0		; specified file name ?
	jz	check_ext		; file name is not specified
	mov	si,offset filename	; append file name
append_file:
	lodsb				;
	cmp	al,0			;
	jz	check_ext		; end of file string
	stosb				;
	jmp	short append_file	;

check_ext:
	cmp	ext,0			; specified file extention
	jz	skip_set_ext		; extention is not specified
	mov	si,offset ext		; append file extent
	mov	byte ptr [di],"."	; append "."
	inc	di			;
append_ext:				;
	lodsb				;
	cmp	al,0			; end of file extention
	jz	skip_set_ext		;
	stosb				;
	jmp	short append_ext	;

skip_set_ext:

	mov	si,offset dest_path	;
	mov	di,offset dest_in_path	;
copy_path:
	lodsb
	cmp	al,0			; end of string ?
	jz	exit_path_copy		;
	stosb				;
	jmp	short copy_path		;

exit_path_copy:
;
;--------------- initialize 
;
	MOV	AL,DEST			;
	ADD	AL,'A'			;
	MOV	D_WILD_FILE,AL		; SET DESTINATION DRIVE NAME
	MOV	DEST_PATH,AL		;
	MOV	DEST_IN_PATH,AL		;
	MOV	CUR_DEST_PATH,AL	;
	MOV	DEST_DIR_PATH,AL	;
	MOV	DEST_PAIR,AL		;
	MOV	DIR_MAKE_PATH,AL	;
	MOV	DEST_ROOT_PATH,AL
	MOV	ENTRY_CHECK_PATH,AL	;
;
	MOV	AL,SOURCE		;
	ADD	AL,'A'			;
	MOV	SOURCE_PATH,AL		; SET SOURCE DRIVE NAME
	MOV	SOURCE_DIR_PATH,AL	;
	MOV	SOURCE_ROOT_PATH,AL	;
	MOV	SOURCE_FILE_PATH,AL	;
	MOV	SOURCE_PAIR,AL		;
	MOV	S_WILD_FILE,AL		;
	MOV	BACKUPID_FILE,AL	;
;
	MOV	MULTI_VOL_EX,0		; MULTI VOLUME EXEC FLAG RESET
	MOV	MULTI_FILE_NO,0		; MULTI FILR NO RESET
	MOV	WARNING_OUT_FLAG,0	; WARNING OUT FLAG RESET
	MOV	WORD PTR VOLUME_NO,0	; EXEC VOLUME NO RESET
	MOV	WORD PTR MULTI_VOL_NO,0	; MULTI VOLUME NO RESET
	MOV	BYTE PTR MULTI_VOL_FL,0	; MULTI VOLUME FLAG RESET
;
	MOV	SI,OFFSET CUR_DEST_PATH+2
	MOV	AH,GET_CUR		;
	MOV	DL,DEST			;
	INC	DL			;
	INT	BDOS			; GET CURRENT DIRECTORY on dest
;*
;****	MEMORY ALOCATE	****
;*
	MOV	BX,OFFSET ENDLOC	;
	MOV	CL,4			;
	SHR	BX,CL			;
	MOV	AH,SETBLOCK		;
	INT	BDOS			;
;
	MOV	BX,0FFFFH		; MEMORY ALLOCATE
	MOV	AH,MEM_ALLOC		;
	INT	BDOS			;
	JNC	RESTORE_START		; success 64k memory
	MOV	AH,MEM_ALLOC		;
	INT	BDOS			; bx = maximum size
RESTORE_START:
	MOV	RESTORE_BUFFER,AX	; SET BUFFER BASE ADDRESS
;
	CALL	RESTORE			; restore process
;
;--------------- return to MS-DOS
;
RESTORE_FIN:
	PUSH	AX			; SAVE AL
	MOV	DX,OFFSET SOURCE_ROOT_PATH
	MOV	AH,CH_DIR
	INT	BDOS			; change dir on diskette
;
	MOV	DI,OFFSET CUR_DEST_PATH
	CALL	SKIP_ZERO
	CMP	DI,OFFSET CUR_DEST_PATH+2
	JNZ	RESTORE_END_00
	MOV	BYTE PTR [DI],'\'	; root path \ set
RESTORE_END_00:
	MOV	DX,OFFSET CUR_DEST_PATH
	MOV	AH,CH_DIR
	INT	BDOS			; change dir on Hard disk
	POP	AX			; RESET AL
;
	MOV	AH,PROC_TERM		; al = terminate code
	INT	BDOS			; return to MS-DOS
	page
;****************************************
;*	RESTORE EXECUTE MAIN		*
;****************************************
RESTORE:
	CALL	PROMPT			; display prompt message
	MOV	AH,SET_DTA
	MOV	DX,OFFSET FIND_BUF_RES
	INT	BDOS			; SET DTA
;*
;****	BACKUP DISKETTE CHECK	****
;*
RESTORE06:
	MOV	DX,OFFSET SOURCE_ROOT_PATH
	MOV	AH,CH_DIR
	INT	BDOS			; CHANGE dir to root on diskette
;
	MOV	DX,OFFSET S_WILD_FILE	;
	MOV	CX,0027H		; SET ATTRIBUTE A,S,H,or R
	MOV	AH,SEARCH_FIRST		;
	INT	BDOS			; FIND MATCH FILE
	JC	RESTORE10		;
 
	MOV	CX,12			;
	MOV	SI,OFFSET BACKUPID_FNAME+1
	MOV	DI,OFFSET FIND_BUF_PNAME
	REP	CMPSB			; check filename "BACKUPID.@@@"
	JE	RESTORE20		;
RESTORE10:
	MOV	SI,OFFSET ERR_MSG_20	;
	JMP	RESTORE_ERR		; error exit
;*
;****	BACKUPID.@@@ FILE READ	****
;*
RESTORE20:
	call	CHK_BACKUPID		; check BACKUPID.@@@ file
	JNC	RESTORE34		;
	JMP	SOURCE_ERR		; ERROR EXIT
;--------------- path and file name set
;
RESTORE34:
	CMP	VOLUME_NO,0		; check first backed up diskette
	JNZ	RESTORE40		; skip set path for diskette
;*
;****	SOURCE PATH SET	****
;*
	call	set_src_path
;*
;****	DMA TRANS ADDRESS SET	****
;*
	MOV	AH,SET_DTA		; 
	MOV	DX,OFFSET FIND_BUF_RES
	INT	BDOS			; SET DTA
;
;--------------- check first parameter
;
	MOV	CX,0010H		; SET ATTRIBUTE D
	MOV	DX,OFFSET SOURCE_PATH
	MOV	AH,SEARCH_FIRST		;
	INT	BDOS			; FIND MATCH FILE on diskette
	JC	RESTORE40		;
	TEST	FIND_BUF_ATTR,10H	; CHECK ATTRIBUTE D
	JZ	RESTORE40		;
	CMP	FIND_BUF_PNAME,2EH	; CHECK '.' DIRECTORY 
	JZ	RESTORE40		;
	CMP	ALL_RS_FLAG,0		; CHECK NO INPUT FILE NAME
	JNZ	RESTORE40		;
;
;--------------- first parameter is path name
;
	MOV	DI,OFFSET SOURCE_PATH	; specified first parameter is path
	CALL	SKIP_ZERO		;
	MOV	SI,OFFSET FILE_WILD	;
	MOV	CX,5			;
	REP	MOVSB			; append "\*.*" and ASCIZ 0
;*
;****	DIRECTORY SET	****
;*
RESTORE40:
	MOV	SI,OFFSET SOURCE_PATH+2	;
	MOV	DI,OFFSET SOURCE_DIR_PATH+2
	CALL	PATH_DIR_CHECK		; set source directory path name
;
	MOV	SI,OFFSET SOURCE_PATH+2	;
	MOV	DI,OFFSET DEST_DIR_PATH+2
	CALL	PATH_DIR_CHECK		; set destination directory path name

	MOV	SI,OFFSET SOURCE_PATH+2
	MOV	DI,OFFSET DEST_IN_PATH+2
	MOV	CX,128
	REP	MOVSB			; SET DEST_IN_PATH

	MOV	DI,OFFSET SOURCE_PATH	;
	CALL	FILE_PICK		; FILE NAME PICK UP
	MOV	SI,DI			;
	MOV	DI,OFFSET SOURCE_FILE_PATH+2
	CALL	TRANS_ASCIZ		; set SOURCE_FILE_PATH
;
	MOV	SI,OFFSET SOURCE_DIR_PATH+3
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	TRANS_ASCIZ		; set PATH_DISP_AREA
;
;---------------  SPECIFIED FILE SEARCH AND CHECK
;
	MOV	SI,OFFSET SOURCE_FILE_PATH+2
	CALL	WILD_CARD_CHECK		; WILD CARD CHECK

	MOV	DX,OFFSET SOURCE_DIR_PATH
	MOV	AH,CH_DIR		;
	INT	BDOS			; change dir on diskette
	JC	RESTORE4024		;
	MOV	DX,OFFSET SOURCE_FILE_PATH
	MOV	CX,0027H		;
	CMP	OPTION_S,0		; SPECIFIED /S OPTION ?
	JZ	RESTORE4023		; /S OPTION IS NOT SPECIFIED
	MOV	CX,0037H		; FILE ATTR. A,D,H,OR,R
RESTORE4023:
	MOV	AH,SEARCH_FIRST		;
	INT	BDOS			; SEARCH FIRST
	JNC	RESTORE4025		;
RESTORE4024:
	CMP	MULTI_VOL_FL,01H	; CHECK MULTI VOLUME
	JZ	RESTORE40240		;
	JMP	RESTORE_NOT_FOUND	; ERROR EXIT
RESTORE40240:
	CMP	WILD_CARD_FLAG,01H	; SPECIFIED WILD CARD FILE NAME ?
	JZ	RESTORE40242		;
	JMP	RESTORE_NOT_FOUND	; ERROR EXIT
RESTORE40242:
	CALL	MULTI_VOLUME_PROCESS	; MULTI VOLUME PROCESS
	JMP	RESTORE06		;
;
;-------------- check volume sequence
;
RESTORE4025:
	CMP	WARNING_OUT_FLAG,0	;
	JNZ	RESTORE4028		;
	MOV	AX,WORD PTR BACKUPID_BUFF+1
	CMP	MULTI_VOL_NO,AX
	JE	RESTORE4028		;
;
	CMP	VOLUME_NO,0		; FIRST VOLUME CHECK
	JNZ	RESTORE4026		; NO
;
;-------------- check file header on the specified filename
;
; Skip BACKUPID.@@@ file and open the specified file. If the file header
; is not 0, display warning message. This process is run only the first
; diskette.
	MOV	CX,12
	MOV	SI,OFFSET BACKUPID_FNAME+1
	MOV	DI,OFFSET FIND_BUF_PNAME
	REP	CMPSB			; compare "BACKUPID.@@@"
	JNE	RESTORE40250		;
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; NEXT SEARCH
RESTORE40250:
	MOV	SI,OFFSET FIND_BUF_PNAME ;
	MOV	DI,OFFSET SOURCE_PATH+2	;
	MOV	CX,13			;
	REP 	MOVSB			; SET SOURCE FILE PATH
;
	MOV	AH,FL_OPEN		;
	MOV	DX,OFFSET SOURCE_PATH	;
	MOV	AL,0			; 
	INT	BDOS			; SPECIFIED READ FOR CHECK
	JC 	RESTORE4026		; NO
;
	MOV	DX,OFFSET FILE_HEADER	;
	MOV	BX,AX			;
	MOV	CX,128			;
	MOV	AH,FL_READ		;
	INT	BDOS			;
	JC	RESTORE4026		; ERROR
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; FILE CLOSE
;
	CMP	BYTE PTR FILE_HEADER,0	; MULTI FILE SEQ CHECK
	JZ	RESTORE4028		; OK
;
RESTORE4026:
	MOV	SI,OFFSET ERR_MSG_60
	CALL	PMSG
	MOV	AX,CON_CHK		;
	INT 	BDOS			; flush buffer and get key
	MOV	WARNING_OUT_FLAG,1	;
	JMP	RESTORE06		; go to check backed up diskette

RESTORE4028:
	MOV	WARNING_OUT_FLAG,0	; RESET WARNING OUT FLAG
	CMP	VOLUME_NO,0   		; check first backed up diskette
	JNZ	RESTORE4029		; no.
;

	MOV	SI,OFFSET DEST_DIR_PATH	;
	CALL	DIR_MAKE		; make dir on Hard disk
;*
;****	START MESSAGE OUT	****
;*
RESTORE4029:
	MOV	SI,OFFSET MSG_10	;
	CALL	PMSG			; BACKUP DATE MESSAGE OUT
	MOV	SI,OFFSET MSG_20	;
	CALL	PMSG			; RESTORE START MESSAGE OUT
;*
;
	MOV	DIRECTORY_COUNT,0	; RESET DIRECTORY COUNT
	MOV	ROOT_COUNT,0		; RESET ROOT COUNT
	MOV	MULTI_FILE_FOUND,0	;
;*
;****	SOURCE DRIVE FIRST SEARCH	****
;*
	MOV	DX,OFFSET SOURCE_FILE_PATH
RESTORE403:
	MOV	CX,0027H		; file attr. A,S,H,or R
	CMP	OPTION_S,0		; specified /s option ?
	JZ	RESTORE404		; /s option is not specified
	MOV	CX,0037H		; file attr. A,D,S,H,or R
RESTORE404:
	MOV	AH,SEARCH_FIRST		;
	INT	BDOS			; search first
;
;					; Skip BACKUPID.@@@ file
	CLD
	MOV	CX,12
	MOV	SI,OFFSET BACKUPID_FNAME+1
	MOV	DI,OFFSET FIND_BUF_PNAME
	REP	CMPSB			; compare "BACKUPID.@@@"
	JNE	RESTORE406		;
;
;--------------- seach next 
;
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; NEXT ENTRY SEARCH
	JNC	RESTORE406		; OK
	CMP	MULTI_VOL_FL,01H	; CHECK MULTI VOLUME
	JZ	RESTORE405		;
	JMP	RESTORE_NOT_FOUND	; ERROR EXIT
RESTORE405:
	CALL	MULTI_VOLUME_PROCESS	;
	JMP	RESTORE06		; go to next diskette process
;
;--------------- last backed up file check
;
RESTORE406:
	CALL	END_FILE_CHECK		; check last backed up file name
	JNZ	RESTORE4060		; no.
	CMP	MULTI_VOL_FL,01H	; check multi volume and not end volume
	JNZ	RESTORE4060		; no.
	CMP	MULTI_FILE_FOUND,0	; check last file not found
	JNZ	RESTORE4060		; no.
;
	MOV	MULTI_FILE_FOUND,1	; last backed up file found
	MOV	SI,OFFSET SOURCE_DIR_PATH+2
	MOV	DI,OFFSET END_PATH_SAVE_AREA
	CALL	TRANS_ASCIZ		; set END_PATH_SAVE_AREA
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET END_FILE_SAVE_AREA
	CALL	TRANS_ASCIZ		; set END_FILE_SAVE_AREA
	JMP	RESTORE_MULTI		; go to multi process
;*
;**** OPTION CHECK , DIRECTORY CHECK	****
;*
RESTORE4060:
	CMP	OPTION_P,0		; specified /p option ?
	JNZ	RESTORE4062		;
	JMP	RESTORE408		; /p option is not specified
RESTORE4062:
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET DEST_PATH+2
	MOV	CX,13
	REP	MOVSB			; set filename and ASCIZ 0
;
	MOV	DX,OFFSET DEST_PATH
	MOV	AL,0
	MOV	AH,CH_MODE		;
	INT	BDOS			; READ DEST FILE ATTRIBUTE
	JC	RESTORE408		;
	TEST	CX,0020H		; CHECK attr. A
	JZ	RESTORE407		; NO
;
;--------------- /p option process. CHECK file was changed after it was backed up 
;
	PUSH	CX			; SAVE attr.
	MOV	DI,OFFSET ERR_MSG_80_10
	MOV	AL,20H
	MOV	CX,13
	REP	STOSB			; clear filname buffer by space
;
	MOV	SI,OFFSET DEST_PATH+2	;
	MOV	DI,OFFSET ERR_MSG_80_10	;
	CALL	TRANS_ASCIZ		; SET FILE NAME
	MOV	BYTE PTR [DI],20H	; append space
;
	MOV	SI,OFFSET ERR_MSG_80	;
	CALL	PMSG			; PROMPT MESSAGE OUT
	MOV	AX,CON_INP		; flush buffer and get
	INT	BDOS			; INPUT Y/N
	PUSH	AX			; save key code
	MOV	SI,OFFSET LINE_FEED
	CALL	PMSG			; c/r l/f
	POP	AX			; load key code
	POP	CX			; RESET attr.
	AND	AL,0DFH			; make low case shift
	CMP	AL,'Y'			; Y CHECK
	JZ	RESTORE407		;
	JMP	RESTORE704		; go to search next
;
RESTORE407:
	TEST	CX,0007H		; CHECK attr. S,H,or R
	JZ	RESTORE408		; NO
;
;--------------- /p option process. 
;
	MOV	DI,OFFSET ERR_MSG_70_10
	MOV	AL,20H
	MOV	CX,13
	REP	STOSB			; clear filname buffer by space
;
	MOV	SI,OFFSET DEST_PATH+2	;
	MOV	DI,OFFSET ERR_MSG_70_10	;
	CALL	TRANS_ASCIZ		; SET FILE NAME
	MOV	BYTE PTR [DI],20H	; append space
;
	MOV	SI,OFFSET ERR_MSG_70	;
	CALL	PMSG			; PROMPT MESSAGE OUT
	MOV	AX,CON_INP		; flush buffer and get
	INT	BDOS			; INPUT Y/N
	PUSH	AX			; save key code
	MOV	SI,OFFSET LINE_FEED
	CALL	PMSG			; c/r l/f
	POP	AX			; load key code
	AND	AL,0DFH			; make low case shift
	CMP	AL,'Y'			; Y CHECK
	JZ	RESTORE408		;
	JMP	RESTORE704		; go to search next
;
RESTORE408:
	TEST	FIND_BUF_ATTR,10H	; check file attr. D
	JNZ	RESTORE4080		;
	JMP	RESTORE42		; go to file restore process

RESTORE4080:
	CMP	FIND_BUF_PNAME,'.'	; check parent dir . 
	JNZ	RESTORE4081		; NO
	JMP	RESTORE410		; go to skip parent dir
;
;--------------- /s option process. change current dir on Hard disk and diskette
;
RESTORE4081:
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET SOURCE_PATH+2
	MOV	CX,13			;
	REP	MOVSB			; SET SOURCE_PATH
;
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET DEST_PATH+2
	MOV	CX,13			;
	REP	MOVSB			; set DEST_PATH
;
	MOV	DI,OFFSET SOURCE_DIR_PATH
	CALL	SKIP_ZERO		;
	CMP	DI,OFFSET SOURCE_DIR_PATH+3
	JZ 	RESTORE4082		; specified root path only
	MOV	BYTE PTR [DI],'\'	; append last path delimiter \
	INC	DI			;
RESTORE4082:
	MOV	SI,OFFSET FIND_BUF_PNAME
	CALL	TRANS_ASCIZ		; SET DIR name to SOURCE_DIR_PATH

	MOV	SI,OFFSET SOURCE_DIR_PATH+2
	MOV	DI,OFFSET DEST_DIR_PATH+2
	MOV	CX,128			;
	REP	MOVSB			; SET DEST_DIR_PATH

	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	SKIP_ZERO
	MOV	BYTE PTR [DI],'\'	; append path delimiter \
	INC	DI
	CALL	TRANS_ASCIZ		; set PATH_DISP_AREA
;
	MOV	DX,OFFSET SOURCE_PATH
	MOV	AH,CH_DIR		;
	INT	BDOS			; change dir on diskette
;
	CMP	MULTI_VOL_EX,1		; ALREADY OPEN
	JZ	RESTORE409
;
;-------------- make dir and change dir on Hard disk
;
	CALL	DIR_ENTRY_CHECK		; DIRECTORY ENTRY FULL CHECK
	JNC	RESTORE4084		; OK
	CMP	AX,5			; FULL ERROR ?
	JNZ	RESTORE4083		;
	MOV	SI,OFFSET ERR_MSG_30	;
	JMP	RESTORE_ERR		; DIRECTORY ENTRY FULL
RESTORE4083:
	JMP	DEST_ERR		; I/O ERROR EXIT
RESTORE4084:
;
	MOV	DX,OFFSET DEST_PATH
	MOV	AH,MK_DIR		;
	INT	BDOS			; MAKE DIRECTORY on Hard disk
	MOV	DX,OFFSET DEST_PATH
	MOV	AH,CH_DIR		;
	INT	BDOS			; change dir on Hard disk
RESTORE409:
	INC	ROOT_COUNT		; COUNT UP ROOT COUNT
	MOV	DX,OFFSET S_WILD_FILE
	JMP	RESTORE403		; go to low level dir
;
;--------------- skip parent dir . and ..
;
RESTORE410:
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; skip .. dir
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; SEARCH NEXT
	JNC	RESTORE411		;
	CMP	MULTI_VOL_FL,00H	; check multi volume
	JNZ	RESTORE4100		; yes
	JMP	RESTORE700		; go to check single volume
RESTORE4100:
	JMP	MULTI_022		; go to check multi volume

RESTORE411:
	JMP	RESTORE406		; go to next entry
;
;--------------- restore file process
;

;
;--------------- open source file and read file header
;
RESTORE42:	
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET SOURCE_PATH+2
	MOV	CX,13
	REP	MOVSB			; SET SOURCE_PATH
;
	MOV	AH,FL_OPEN
	MOV	DX,OFFSET SOURCE_PATH
	MOV	AL,0			; READ OPEN
	INT	BDOS			; SOURCE FILE OPEN
	JC	RESTORE44		;
;
	MOV	SOURCE_HAND,AX		;
;
	MOV	DX,OFFSET FILE_HEADER	; READ OFFSET ADDRESS
	MOV	BX,CS:SOURCE_HAND	;
	MOV	CX,128			;
	MOV	AH,FL_READ		; read file header
	INT	BDOS			;
	JNC	RESTORE440		;
RESTORE44:
	JMP	SOURCE_ERR		; ERROR EXIT

RESTORE440:
	MOV	AL,BYTE PTR FILE_HEADER	;
	CMP	AL,MULTI_FILE_NO	; FILE SEQ CHECK
	JZ	RESTORE442		; OK
	MOV	SI,OFFSET ERR_MSG_10	;
	JMP	RESTORE_ERR		; ERROR EXIT

RESTORE442:
	CALL	FILE_DISP		; FILE NAME DISPLAY
;
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET DEST_PATH+2
	MOV	CX,13
	REP	MOVSB			; set DEST_PATH
;
	CMP	MULTI_VOL_EX,1		; ALREADY OPEN ?
	JE	RESTORE48		; skip open file on Hard disk
;
;--------------- open file on Hard disk
;

RESTORE448:
	MOV	AH,FL_OPEN
	MOV	DX,OFFSET DEST_PATH
	MOV	AL,1			; WRITE OPEN
	INT	BDOS			; OPEN DESTINATION FILE
	JNC	RESTORE46	
;
	CMP	AX,5			; FILE =READ ONLY CHECK
	JNE	RESTORE45		; go to creat file on Hard disk
	MOV	AH,CH_MODE		;
	MOV	DX,OFFSET DEST_PATH	;
	MOV	CX,0020H		;
	MOV	AL,01H			;
	INT	BDOS			; change file attr. to write
	JMP	SHORT RESTORE448	; retry open file on Hard disk

RESTORE45:
	MOV	AH,FL_CREAT		;
	MOV	DX,OFFSET DEST_PATH	;
	MOV	CX,0020H		;
	INT	BDOS			; CREATE file on Hard disk
	JNC	RESTORE46		;
;
	CMP	AX,5			; ENTRY FULL CHECK
	JNZ	RESTORE450		; NO
	MOV	SI,OFFSET ERR_MSG_30	;
	JMP	RESTORE_ERR		; ERROR EXIT
RESTORE450:
	JMP	DEST_ERR		; ERROR EXIT (I/O ERROR)
;
;--------------- copy file data
;
RESTORE46:
	MOV	DEST_HAND,AX		; SET DESTINATION FILE HANDLE
RESTORE48:
	MOV	MULTI_VOL_EX,0		; MULTI VOLUME EXCHANGE OFF
RESTORE50:
	PUSH	DS			;
	MOV	DS,RESTORE_BUFFER	; READ BASE ADDRESS
	XOR	DX,DX			; READ OFFSET ADDRESS
	MOV	CX,8000H		; 32K
	MOV	AH,FL_READ		; READ
	MOV	BX,CS:SOURCE_HAND	;
	INT	BDOS			;
	POP	DS			;
	JNC	RESTORE52		;
	JMP	SOURCE_ERR		; ERROR EXIT
;
RESTORE52:
	CMP	AX,0			; END OF FILE ?
	JE	RESTORE60		; YES
	MOV	WTLNG,AX		;
	PUSH	DS			;
	MOV	DS,RESTORE_BUFFER	; WRITE BASE ADDRESS
	XOR	DX,DX			; WRITE OFFSET ADDRESS
	MOV	CX,AX			; WRITE LENGTH
	MOV	BX,CS:DEST_HAND		;
	MOV	AH,FL_WRITE		; WRITE
	INT	BDOS			; WRITE DESTINATION FILE
	POP	DS			;
	JNC	RESTORE54		; OK
	JMP	DEST_ERR		; ERROR

RESTORE54:
	CMP	AX,WTLNG		; DESTINATION FILE CHECK
	JE	RESTORE50		; OK
;
;-------------- no available space on Hard disk
;
	MOV	BX,DEST_HAND		;
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; DESTINATION FILE CLOSE
;
	MOV	DX,OFFSET DEST_PATH	;
	MOV	AH,DEL_FILE		;
	INT	BDOS			; FILE DELETE
;
	MOV	SI,OFFSET ERR_MSG_30	;
	JMP	RESTORE_ERR		; error exit
;
;--------------- check multi volume file
;
RESTORE60:
	CMP	MULTI_VOL_FL,00H	; check multi volume flag
	JE	RESTORE62		;
	JMP	RESTORE_MULTI		; go to multi-volume process
;
RESTORE62:
	MOV	SI,OFFSET FIND_BUF_ATTR
	MOV	DI,OFFSET FIND_BUF_ATTR_S
	MOV	CX,5
	REP	MOVSB			; SET old FILE ATTR,TIME,DATE
;
	CALL	FILE_CLOSE		; close files on diskette and HD
;
	JNC	RESTORE70		;
	JMP	RESTORE_ERR		; error exit
;
;--------------- search next file
;
RESTORE70:
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; NEXT FILE search
	JNC	RESTORE74
RESTORE700:
	CMP	ROOT_COUNT,0		; CHECK ROOT COUNT
	JZ	RESTORE72		;
	CALL	DIR_PAIR_BACK		; back to parent dir
RESTORE704:
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; search next
	JC	RESTORE700		;
	JMP	RESTORE406		; go to next entry

RESTORE72:
	JMP	RESTORE_END		; normal end

RESTORE74:
	MOV	MULTI_FILE_NO,0		;
	JMP	RESTORE406		;
	page
;****************************************
;*	MULTI VOLUME END PROCESS	*
;****************************************
RESTORE_MULTI:
	MOV	SI,OFFSET FIND_BUF_ATTR
	MOV	DI,OFFSET FIND_BUF_ATTR_S
	MOV	CX,5
	REP	MOVSB			; SET old FILE ATTR,TIME,DATE
;
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; NEXT SEARCH
	JC	MULTI_02		;
	CMP	MULTI_FILE_FOUND,3	; last backed up file copied ?
	JZ	MULTI_05		; go to multi volume file copy

	CMP	MULTI_FILE_FOUND,1	; last backed file found ?
	JNZ	MULTI_000		; SKIP
	MOV	MULTI_FILE_FOUND,2	; already skip last backed up file
	MOV	MULTI_FILE_NO,0		; FILE SEQ NO RESET
	JMP	RESTORE406		; go to next entry

MULTI_000:
	CALL	FILE_CLOSE		; close files on diskette and HD
	jc	multi_err		; close error
	MOV	MULTI_FILE_NO,0		; FILE SEQ NO RESET
	JMP	RESTORE406		; go to next entry

MULTI_02:
	CMP	MULTI_FILE_FOUND,3	; check last backed up file
	JZ	MULTI_05		; no , go to multi file copy
 
	CMP	MULTI_FILE_FOUND,1	; CHECK LAST BACKED UP FILE FOUND
	JNZ	MULTI_021		; SKIP
	MOV	MULTI_FILE_FOUND,2	; already skip last backed up file
	JMP	MULTI_022		;
MULTI_021:
	CALL	FILE_CLOSE		; close files on diskette and HD
	jc	multi_err		; close error
MULTI_022:
	CMP	ROOT_COUNT,0		; ROOT CHECK
	JZ	MULTI_04		;
	CALL	DIR_PAIR_BACK		; back to parent dir
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; search next
	JC	MULTI_022		; no entry in the dir
	JMP	RESTORE406		; go to next entry

multi_err:
	jmp	restore_err		; error exit


MULTI_04:
	CMP	MULTI_FILE_FOUND,0	; check multi file copy
	JNZ 	MULTI_040		; COPY LAST BACKED UP FILE
	CMP	WILD_CARD_FLAG,1	; check specified wild card on file name
	JZ	MULTI_05		; go to multi process
	JMP	RESTORE_END		; go to normal end
;
;--------------- search last backed up file again
;
MULTI_040:
	call	search_last		; 
	MOV	MULTI_FILE_FOUND,3	; restore last backed up file
	JMP	RESTORE406		; go to next entry
;
;--------------- copy multi volume file
;
MULTI_05:
;
	CMP	MULTI_VOL_FL,0FFH	; check multi volume file
	JNE 	MULTI_08		; no.
	CMP	BACKUPID_BUFF+256,0	; CHECK <DIR> ONLY BACKED UP DISKETTE
	JZ	MULTI_06		; YES, SKIP
	CMP	MULTI_FILE_FOUND,0	; CHECK LAST BACKED UP FILE COPY ?
	JZ	MULTI_06		; NO
	CALL	FILE_CLOSE		; close files on diskette and HD
	jc	multi_err		; close error
MULTI_06:
	JMP	RESTORE_END		; go to normal end

MULTI_08:
	CMP	MULTI_FILE_FOUND,0	; CHECK LAST BACKED UP FILE COPY ?
	JZ	MULTI_11		; NO
	CMP	BACKUPID_BUFF+3,0	; check multi volume file sequence
	CMP	AL,0			; FILE SEQ CHECK
	JNZ	MULTI_09		; FILE MULTI
;
	CMP	BACKUPID_BUFF+256,0	; NO FILE COPY ?
	JZ	MULTI_11
	CALL	FILE_CLOSE		; FILE CLOSE
	jc	multi_err		; close error
	JMP	MULTI_11		;
MULTI_09:
	MOV	BX,SOURCE_HAND		;
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; close file on diskette
	JNC	MULTI_10		;
	JMP	SOURCE_ERR		; error exit
;
MULTI_10:
	INC	BYTE PTR MULTI_FILE_NO
	MOV	MULTI_VOL_EX,1		; SET ON MULTI VOLUME EXEC FLAG
MULTI_11:
	CALL	MULTI_VOLUME_PROCESS	; MULTI VOLUME PROCESS EXEC
	JMP	RESTORE06		; go to next diskette process
;
;--------------- source drive i/o error
;
SOURCE_ERR:
	MOV	SI,OFFSET ERR_MSG_40
	JMP	RESTORE_ERR
;
;--------------- destination drive i/o error
;
DEST_ERR:
	MOV	SI,OFFSET ERR_MSG_50
;
;--------------- restore error exit
;
RESTORE_ERR:
	CALL	PMSG			; ERROR MESSAGE OUT
	MOV	AL,4			; terminate code 4
	RET
;
;--------------- file not found error
;
RESTORE_NOT_FOUND:
	MOV 	SI,OFFSET ERR_MSG_90	;
	CALL	PMSG			; ERROR MESSAGE OUT
	MOV	AL,1			;
	RET				;
;
;--------------- restore normal end
;
RESTORE_END:
;
	MOV	AL,0			; terminate code 0
	RET				; return to main
	page
;**************************************************************
;*			
;*     SUBROUTIN	
;*			
;**************************************************************
;----------------------------------------------------------------
; check BACKUPID.@@@ file
;----------------------------------------------------------------
CHK_BACKUPID	proc
	MOV	AH,FL_OPEN
	MOV	DX,OFFSET BACKUPID_FILE
	MOV	AL,0			; read open
	INT	BDOS			; 'BACKUPID.@@@' FILE OPEN
	JC	CHK_ID_ERR		; error

	MOV	SOURCE_HAND,AX		; save file handler
	MOV	AH,FL_READ
	MOV	DX,OFFSET BACKUPID_BUFF
	MOV	CX,512			; SET READ LENGTH
	MOV	BX,SOURCE_HAND		; 
	INT	BDOS			; READ 'BACKUPID.@@@' FILE
	JC	CHK_ID_ERR		; error
 
	MOV	AL,BACKUPID_BUFF	;
	MOV	MULTI_VOL_FL,AL		; SET MULTI VOLUME FLAG
	MOV	AX,WORD PTR BACKUPID_BUFF+1
	MOV	MULTI_VOL_NO,AX		; SET MULTI VOLUME NO
	MOV	SI,OFFSET MSG_22	;
	CALL	BINASCII		; SET VOLUME NO ON MESSAGE AREA
;
	MOV	SI,OFFSET MSG_12	;
	CALL	DATE_SET		; BACKUP DATE SET
	MOV	AH,FL_CLOSE		;
	MOV	BX,SOURCE_HAND		;
	INT	BDOS			; CLOSE 'BACKUPID.@@@' FILE
CHK_ID_ERR:
	ret
CHK_BACKUPID	endp
;---------------------------------------------------------------------
; set source path
;---------------------------------------------------------------------
set_src_path	proc
	MOV	CX,128			;
	MOV	SI,OFFSET DEST_PATH+2	;
	MOV	DI,OFFSET SOURCE_PATH+2	;
	REP	MOVSB			; SET SOURCE PATH
;
	MOV	AL,DEST_PATH+2		;
	CMP	AL,'\'			; check root path delimiter \
	JZ	set_src_02
;
	MOV	SOURCE_PATH+2,'\'	; append last path delimiter \
	MOV	SI,OFFSET CUR_DEST_PATH+2
	MOV 	DI,OFFSET SOURCE_PATH+3
	CALL	TRANS_ASCIZ		; set absolute SOURCE_PATH

	MOV	DI,OFFSET SOURCE_PATH+2	;
	CALL	SKIP_ZERO		;
	CMP	DI,OFFSET SOURCE_PATH+3	; check root path only
	JZ	set_src_01		; yes.
	MOV	BYTE PTR [DI],'\'	; append last path delimiter \
	INC	DI			;
set_src_01:
	MOV 	SI,OFFSET DEST_PATH+2
	CALL	TRANS_ASCIZ		; set SOURCE_PATH
set_src_02:
	CMP	ALL_RS_FLAG,0		; check no specified file name
	JZ	set_src_ret
	MOV	DI,OFFSET SOURCE_PATH+2	;
	CALL	SKIP_ZERO		;
	MOV	SI,OFFSET FILE_WILD+1	;
	MOV	CX,4			;
	REP	MOVSB			; append "*.*" and ASCIZ 0
set_src_ret:
	ret
set_src_path	endp
;-----------------------------------------------------------------
; search last backed up file
;-----------------------------------------------------------------
search_last	proc
	MOV	SI,OFFSET END_PATH_SAVE_AREA
	MOV	DI,OFFSET SOURCE_DIR_PATH+2
	MOV	CX,128
	REP	MOVSB			; set SOURCE_DIR_PATH

	MOV	SI,OFFSET END_PATH_SAVE_AREA+1
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	TRANS_ASCIZ		; set PATH_DISP_AREA
;
	MOV	DX,OFFSET SOURCE_DIR_PATH
	MOV	AH,CH_DIR
	INT	BDOS			; change dir on diskette
	MOV	SI,OFFSET END_PATH_SAVE_AREA
	MOV	DI,OFFSET DEST_DIR_PATH+2
	MOV	CX,128
	REP	MOVSB			; set DEST_DIR_PATH
;
	MOV	SI,OFFSET DEST_DIR_PATH
	CALL	DIR_MAKE		; make dir on Hard disk
;
	MOV	CX,0027H		; file attr. A,S,H,or R
	CMP	OPTION_S,0		; specified /s option ?
	JZ	last01			; /s option is not specified
	MOV	CX,0037H		; file attr. A,D,S,H,or R
last01:
	MOV	DX,OFFSET SOURCE_FILE_PATH
	MOV	AH,SEARCH_FIRST
	INT	BDOS			; search first on diskette
last02:
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET END_FILE_SAVE_AREA
	CALL	FILE_NAME_CHECK
	JZ	last03			; skip search next
	MOV	AH,SEARCH_NEXT
	INT	BDOS			; search next
	JMP	last02
last03:
	ret
search_last	endp
;****************************************
;*	MULTI VOLUME PROCESS		*
;****************************************
MULTI_VOLUME_PROCESS:
	MOV	MULTI_FILE_FOUND,0	; REST MULTI FILE SWITCH
	INC	VOLUME_NO		; VOLUME NO COUNT UP
;
	MOV	DI,OFFSET PATH_DISP_AREA
	MOV	AL,0
	MOV	CX,128
	REP	STOSB			; set PATH_DISP_AREA
;
	INC	MULTI_VOL_NO		; MULTI VOLUME NO COUNT UP
	CALL	PROMPT			; require next diskette
	MOV	SI,OFFSET DEST_IN_PATH+2
	MOV	DI,OFFSET SOURCE_PATH+2
	MOV	CX,128
	REP	MOVSB			; set SOURCE_PATH
	RET
;****************************************
;*	CHECK WILD CARD ON FILE NAME	*
;****************************************
;			<INPUT>	SI = FILE NAME POINTER
;
WILD_CARD_CHECK:
	MOV	WILD_CARD_FLAG,0	; RESET WILD CARD FLAG
WILD_CARD_CHECK_00:
	LODSB
	CMP	AL,0			; END CHECK
	JZ	WILD_CARD_CHECK_END	;
	CMP	AL,'*'			; '*' CHECK
	JZ	WILD_CARD_CHECK_10	; YES
	CMP	AL,'?'			; '?'
	JNZ	WILD_CARD_CHECK_20	; NO
WILD_CARD_CHECK_10:
	MOV	WILD_CARD_FLAG,1	; SET WILD CARD FLAG
	JMP	SHORT WILD_CARD_CHECK_END
WILD_CARD_CHECK_20:
	JMP	SHORT WILD_CARD_CHECK_00
WILD_CARD_CHECK_END:
	RET				;
;************************
;*   FILE CLOSE		*
;************************
;	<OUTPUT> :  CF  = OFF   NORMAL RETURN
;			= ON    ERROR
FILE_CLOSE:
	MOV	BX,SOURCE_HAND		;
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; SOURCE FILE CLOSE
	JNC	FILE_CLOSE_10		;
	MOV	SI,OFFSET ERR_MSG_40	;
	JMP	FILE_CLOSE_ERR		;
;
FILE_CLOSE_10:
	MOV	BX,DEST_HAND		;
	MOV	AL,1			; SET MODE
	MOV	CX,FIND_BUF_TIME_S	;
	MOV	DX,FIND_BUF_DATE_S	;
	MOV	AH,FILE_TIME_DATE	;
	INT	BDOS			; SET TIME & DATE ON DEST FILE
	JNC	FILE_CLOSE_20		;
	MOV	SI,OFFSET ERR_MSG_50	;
	JMP	FILE_CLOSE_ERR		;

FILE_CLOSE_20:
	MOV	BX,DEST_HAND		;
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; DESTINATION FILE CLOSE
	JNC	FILE_CLOSE_30		;
	MOV	SI,OFFSET ERR_MSG_50	;
	JMP	FILE_CLOSE_ERR		;
;
FILE_CLOSE_30:
	MOV	AH,CH_MODE		;
	MOV	AL,01H			;
	MOV	DX,OFFSET DEST_PATH	;
	MOV	CH,0			;
	MOV	CL,FIND_BUF_ATTR_S	;
	INT	BDOS			; SET ATTRIBUTE ON DESTINATION FILE
	JNC	FILE_CLOSE_END		;
      	MOV	SI,OFFSET ERR_MSG_50	;
;
FILE_CLOSE_ERR:
	STC				;
	RET				;
FILE_CLOSE_END:
	CLC				;
	RET				;
;****************************************
;*   DIRECTORY ENTRY FULL CHECK		*
;****************************************
;*		OUT : CF = OFF	NORMAL RETURN
;*			 = ON	ERROR
;*				AX = 5	   : ENTRY FULL
;*				   = ELSE  : I/O ERROR
;
DIR_ENTRY_CHECK:
	PUSH	DX			;
	CLC				;
;
	CMP	ROOT_COUNT,0		; ROOT CHECK
	JNZ	DIR_ENTRY_END		; NO EXIT
	CMP	CUR_DEST_PATH+2,0	; ROOT DIRECTORY CHECK
	JNZ	DIR_ENTRY_END		; NO EXIT
;
	MOV	DX,OFFSET ENTRY_CHECK_PATH
	MOV	AH,MK_DIR		;
	INT	BDOS			; MAKE DIRECTORY FOR CHECK
	JNC	DIR_ENTRY_10		; OK
;
	MOV	AX,5			; FOR BUG OF DOS ?
	JMP	SHORT DIR_ENTRY_END	;
DIR_ENTRY_10:				;
	MOV	DX,OFFSET ENTRY_CHECK_PATH
	MOV	AH,RM_DIR		;
	INT	BDOS			; REMOVE DIRECTORY
DIR_ENTRY_END:
	POP	DX			; RESET RG.
	RET				;
;********************************
;*   PROMPT MESSAGE OUT		*
;********************************
;	<INPUT>  :  SI  =  PRINT MESSSAGE POINTER
;
PMSG:
	PUSH	DS			; PRINT MESSAGE AT [SI] TO ZERO
	PUSH	CS			;
	POP	DS			; DS<=CS
	CLD				;
PMSG10:
	LODSB				; GET A CHARACTER
	TEST	AL,AL			; SEE , IF ZERO TERMINATIOR
	JZ	PMSG_X			; YES EXIT
	PUSH	SI			; SAVE POINTER
	CALL	CONOUT			; NOT DONE PRINT CHARACTER
	POP	SI			; RECOVER POINTER
	JMP	SHORT PMSG10		; AND LOOP
PMSG_X:
	POP	DS
	RET
;********************************
;*   CONSOLE OUT ROUTIME	*
;********************************
CONOUT:
	MOV	DL,AL			; SET CHARACTER
	MOV	AH,CON_OUT		; CONSOLE OUTPUT
	INT	BDOS			; 
	RET				;
;************************
;*   PROMPT		*
;************************
PROMPT:
	MOV	AL,SOURCE		;
	ADD	AL,'A'			;
	MOV	PROMPT_MSG_10,AL	;
	MOV	AX,MULTI_VOL_NO		;
	MOV	SI,OFFSET PROMPT_MSG_00	;
	CALL	BINASCII		; VOLUME NO SET
	MOV	SI,OFFSET MSG_22	;
	CALL	BINASCII		;
;
	MOV	SI,OFFSET PROMPT_MSG
	CALL	PMSG
;
	MOV	AX,CON_CHK		;
	INT	BDOS			;
	RET				;
;********************************
;* 	FILE NAME DISPLAY	*
;********************************
FILE_DISP:
	PUSH	SI			;
	PUSH	DI			;
	PUSH	CX			;
	PUSH	AX			;
;
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	SKIP_ZERO		;
	CMP	DI,OFFSET PATH_DISP_AREA ; PATH DISPLAY ?
	JZ	FILE_DISP_00		; NO . SKIP
;
	MOV	SI,OFFSET PATH_DISP_AREA
	MOV	DI,OFFSET CUR_DEST_PATH+2
FILE_DISP_0S:
	LODSB				; CURRENT PATH CHECK
	CMP	AL,[DI]
	JNZ	FILE_DISP_1S
	CMP	AL,0
	JZ	FILE_DISP_00
	INC	DI
	JMP	SHORT FILE_DISP_0S
FILE_DISP_1S:
	DEC	SI
	CMP	BYTE PTR [SI],'\'	; check path delimiter \
	JNZ	FILE_DISP_2S
	INC	SI
FILE_DISP_2S:
	CALL	PMSG			; DISPLAY PATH NAME
	MOV	AL,'\'
	CALL	CONOUT			;
;
FILE_DISP_00:
	MOV	DI,OFFSET FILE_DISP_AREA
	MOV	CX,13			;
	MOV	AL,20H			;
 	REP	STOSB			; SET BLANK
;
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET FILE_DISP_AREA
	MOV	CX,13			;
FILE_DISP_01:
	MOV	AL,[SI]			;
	CMP	AL,0			;
	JE	FILE_DISP_10		;
	MOV	[DI],AL			;
	INC	SI			;
	INC	DI			;
	DEC	CX			;
	JNZ	FILE_DISP_01		;
FILE_DISP_10:
	MOV	SI,OFFSET FILE_DISP_AREA
	CALL	PMSG			; DISPLAY FILE NAME
;
	POP	AX			;
	POP	CX			;
	POP	DI			;
	POP	SI			;
	RET
;********************************
;*   DATE SET			*
;********************************
;	<INPUT>  :  SI  = DATE SET AREA POINTER
;
DATE_SET:
	MOV	AX,FIND_BUF_DATE	; set mounth of file
	MOV	CL,5
	SHR	AX,CL
	AND	AX,000FH
	CALL	SET_20
;
	MOV	AX,FIND_BUF_DATE	; set day of file
	AND	AX,001FH
	INC	SI
	CALL	SET_20
;
	MOV	AX,FIND_BUF_DATE	; set year of file
	MOV	CL,9
	SHR	AX,CL
	ADD	AX,1980			; add 1980
	INC	SI
	CALL	SET_10
	RET
;
SET_10:
	MOV	BX,1000			; four degit check
	MOV	DX,0
	DIV	BX
	OR	AL,30H
	MOV	[SI],AL			; 1000 degit set
	INC	SI
	MOV	AX,DX
;
	MOV	BX,100
	MOV	DX,0
	DIV	BX
	OR	AL,30H
	MOV	[SI],AL			; 100 degit set
	INC	SI
	MOV	AX,DX
;
SET_20:
	MOV	BL,10			; two degit check
	DIV	BL
	OR	AL,30H
	MOV	[SI],AL			; 10 degit set
	INC	SI
	OR	AH,30H
	MOV	[SI],AH			; 1 degit set
	INC	SI
	RET
;************************
;*   DIRECTORY MAKE	*
;************************
DIR_MAKE:
	PUSH	AX
	PUSH	DI
	MOV	DX,OFFSET DEST_ROOT_PATH
	MOV	AH,CH_DIR
	INT	BDOS
DIR_MAKE_00:
	MOV	DI,OFFSET DIR_MAKE_PATH+2
DIR_MAKE_10:
	MOV	AL,[SI+3]
	CMP	AL,'\'			; check path delimiter 
	JZ	DIR_MAKE_20		;
	CMP	AL,0			; check ASCIZ 0
	JZ	DIR_MAKE_20		;
	MOV	[DI],AL			; SET DIRECTORY
	INC	SI			;
	INC	DI			;
	JMP	SHORT DIR_MAKE_10
DIR_MAKE_20:
	PUSH	AX			;
	MOV	BYTE PTR [DI],0
	MOV	DX,OFFSET DIR_MAKE_PATH
	MOV	AH,MK_DIR		;
	INT	BDOS			;
	MOV	DX,OFFSET DIR_MAKE_PATH
	MOV	AH,CH_DIR		; 
	INT	BDOS			; CHANGE DIRECTORY
;
	INC	SI			;
	POP	AX			;
	CMP	AL,0			; check ASCIZ 0
	JZ	DIR_MAKE_END		;
	JMP	SHORT DIR_MAKE_00
DIR_MAKE_END:
	POP	DI			;
	POP	AX			;
	RET				;
;****************************************
;*   DIRECTORY PARENT BACK		*
;****************************************
DIR_PAIR_BACK:
	MOV	DX,OFFSET SOURCE_PAIR	;
	MOV	AH,CH_DIR		;
	INT	BDOS			; change dir on diskette
;
	MOV	DX,OFFSET DEST_PAIR	;
	MOV	AH,CH_DIR		;
	INT	BDOS			; change dir on Hard disk
;
	DEC	ROOT_COUNT		; ROOT COUNT DOWN
;
	MOV	DI,OFFSET SOURCE_DIR_PATH
	CALL	FILE_PICK		; FILE NAME PICK UP
	MOV	SI,DI			;
	MOV	DI,OFFSET CUR_FILE_NAME	;
	CALL	TRANS_ASCIZ		;

	MOV	DI,OFFSET SOURCE_DIR_PATH
	CALL	PATH_DIR_PAIR		;
	MOV	DI,OFFSET DEST_DIR_PATH
	CALL	PATH_DIR_PAIR		;
	MOV	DI,OFFSET PATH_DISP_AREA 
	CALL	PATH_DIR_PAIR		;
;
	MOV	CX,0037H		; file attr. A,D,S,H,or R
	MOV	DX,OFFSET S_WILD_FILE	;
	MOV	AH,SEARCH_FIRST		;
	INT	BDOS			; search first
DIR_PAIR_BACK_00:
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET CUR_FILE_NAME	;
	CALL	FILE_NAME_CHECK		; FILE NAME CHECK
	JZ	DIR_PAIR_BACK_10	;
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; search next
	JMP	SHORT DIR_PAIR_BACK_00
DIR_PAIR_BACK_10:
	RET
;************************
;*   END FILE CHECK	*
;************************
;
;	<OUTPUT>  :   Z flag on if same filename
;
END_FILE_CHECK:
	MOV	SI,OFFSET SOURCE_DIR_PATH+2
	MOV	DI,OFFSET END_FILE_CHECK_AREA
	MOV	CX,126
	REP	MOVSB			; set END_FILE_CHECK_AREA
;
	MOV	DI,OFFSET END_FILE_CHECK_AREA
	CALL	SKIP_ZERO

	MOV	BYTE PTR [DI],'\'	; append path delimiter \
	INC	DI
	MOV	SI,OFFSET FIND_BUF_PNAME
	CALL	TRANS_ASCIZ		; append filename
;
	MOV	SI,OFFSET BACKUPID_BUFF+256
	MOV	DI,OFFSET END_FILE_CHECK_AREA
	CALL	FILE_NAME_CHECK
	RET
include b:backrest.inc
;
;
	ORG	$
	IF	($ - BEGIN ) MOD 10H
	ORG	($ - BEGIN ) + 10H -  (($ - BEGIN) MOD 10H )
	ENDIF
ENDLOC	LABEL	BYTE
CODE	ENDS
	END	START

R

N

$

Y

N

V

O

S

	




O

