program PlayWithTurtle;

{$I Graph.p  }

{       Here is a list of the commands that this program uses:

          Cursor Keys:
            Up arrow,
            Down arrow,
            Right arrow,
            Left arrow:  Points turtle in specified direction.
            Home:        Positions turtle at the center of the screen.

          Alpha keys:
            U:           PenUp.
            D:           PenDown.
            R:           Turns turtle to the right.
            L:           Turns turtle to the left.
            0 thru 9:    Sets magnitude for speed.
                         (i.e. 0 is stopped, 1 is slow, 9 is fast)
            W:           Wrap is on.
            N:           Turns wrap off.
            H:           Hides the turtle.
            S:           Shows the turtle.
            P:           Changes the color (or intensity) of the lines.
            C:           Clears the screen and homes the turtle.
            G:           Sets video mode to High resolution.
            M:           Sets video mode to Medium resolution.
            Q:           Quits turtle demo.

}




 Procedure PlayWithTurtle;
 var InKey:     Char;
     Magnitude,             { This is for speed }
     Color:     Integer;    { Current palette color }
     FuncFlag:  Boolean;    { Indicates function key }

  Procedure InitializeVariables;
  begin
    Magnitude := 0;         { Stopped           }
    Color     := 0;
  end;

  Function GetKey(var FuncFlag: Boolean): char;
  var ch: char;
  begin
    read(kbd,Ch);
    If (Ch = #27) AND KeyPressed Then  { it must be a function key }
    begin
      read(kbd,Ch);
      FuncFlag := true;
    end
    else FuncFlag := false;
    GetKey := Ch;
  end;


 begin
  InitializeVariables;
  repeat
   repeat
     if Magnitude <> 0 then forwd(Magnitude);
   until KeyPressed;
   Inkey := GetKey(FuncFlag);

   If FuncFlag then
    case Upcase(Inkey) of
      'H': SetHeading(North);  { Up arrow Key    }
      'P': SetHeading(South);  { Down arrow Key  }
      'M': SetHeading(East);   { Left arrow Key  }
      'K': SetHeading(West);   { Right arrow Key }
      'G': Home;
    end
   else
   case upcase(InKey) of
     'U': PenUp;
     'D': PenDown;
     'W': Wrap;
     'N': NoWrap;
     'H': HideTurtle;
     'S': ShowTurtle;
     'R': SetHeading(Heading+5);
     'L': SetHeading(Heading-5);
     'P': begin
            Color := succ(color) mod 4;
            SetPenColor(Color);
          end;
     '0'..'9': Magnitude := Sqr(ord(inkey) - ord('0'));
     'C': begin
            ClearScreen;
            Home;
            ShowTurtle;
            Magnitude := 0;
            wrap;
          end;
     'M': begin
            Graphics;
            Home;
            wrap;
            ShowTurtle;
            Magnitude := 0;
          end;
     'G': begin
            Hires;
            Home;
            ShowTurtle;
            Magnitude := 0;
            wrap;
          end;
   end;   { case }
  until UpCase(Inkey) in ['Q',#27];
 end;  { PlayWithTurtle }

begin
  Graphics;
  ClearScreen;
  Showturtle;
  home;
  Wrap;
  PlayWithTurtle;
  ClearScreen;
  TextMode;
end.
