;	IOS.ASM FILE FOR SPELLBINDER 
;	TO RUN ON A SERIAL TERMINAL
;
;	COPYRIGHT 1979,1982 BY LEXISOFT, INC.
;	DAVIS, CALIFORNIA
;	
;	VERSION 5.12  --  MARCH 1982
;
BASE	EQU 0
IOBYT	EQU BASE+3
DOS	EQU BASE+5
	ORG BASE+5F00H
TXADR	DW BASE+6300H	;MARKS START OF TEXT REGION
;
MONIT:	JMP EXIT	;COMMAND X EXIT FROM SPELL BINDER
CONIN:	JMP TIN		;READ KEYBOARD, RETURN IN A
CONST:	JMP TST		;RETURN A NON-ZERO IF KEY READY
LIST:	JMP CPRNT	;PRINT THE CHARACTER IN C
INIT:	JMP INT		;COLD INITIALIZE HARDWARE
SEROT:	JMP SPRNT	;SEND A TO THE SERIAL PORT
	JMP RETRN
	JMP RETRN
CCOUT:	JMP UCOUT	;SEND A TO PRECISION PRINTER
CARRG:	JMP UCARR	;MOVE CARRIAGE LEFT/RIGHT
ROLL:	JMP UROLL	;MOVE FORM UP/DOWN
RESTR:	JMP UREST	;READY PRECISION PRINTER
HYOFF:	JMP UOFF	;TURN OFF PRECISION PRINTER
AUXRD:	JMP ARD		;READ FROM CASSETTE
AUXWT:	JMP AWT		;WRITE TO CASSETTE
SERA:	JMP TERM	;TERMINAL I/O
CURAD:	JMP TERMXY	;CURSOR ADDRESSING
LSTST:	JMP LSTAT
DSKST:	JMP DSTAT
	JMP RETRN
	JMP RETRN
;
;	USER TABLE DEFINES THE SPECIAL PRINTER FUNCTIONS
;	THIS VECTOR IS TO A LATER TABLE OF THREE BYTE ENTRIES
;
USTAB	DW	PTABLE

;	VECTORS TO HELP MESSAGES AT END OF IOS FILE
;
HSCRL	DB 0
HSFLG	DB 0
HMSGS	JMP HHAND
	DW 0
DRVS	DB 0
SPEED	DB 44		;DELAY FOR A 4 MHZ MACHINE
SPOOL	DW 0
DATS:	DW 0,0,0,0,0,0
;
;
;	SEE SPELLBINDER TECHNICAL MANUAL FOR A DESCRIPTION OF
;	THE KEYBOARD AND TERMINAL CONFIGURATION TABLES BELOW
;
;	KEYBOARD TYPE TABLE -- SUMMARIZES KEYBOARD FEATURES
;
KTYPE1	DB 0		;BIT MAPPED KEYBOARD FEATURES
KTYPE2	DB 0		;MULTI-KEY SEQUENCE 1
KTYPE3	DB 0		;TERMINATOR 1
KTYPE4	DB 0		;MULTI-KEY SEQUENCE 2
KTYPE5	DB 0		;TERMINATOR 2
	DB 0,0,0	;EXTRAS
;
;	TABLE FOR EDITING FUNCTION KEYS
;	THIS VERSION USES CONTROL CHARACTERS
;	REPLACE BYTE WITH ANY VALUE DESIRED
;	TO CREATE SPECIAL FUNCTION KEYS
;
;	MULTI-KEY FUNCTION KEYS ARE REPLACED WITH THE CODE
;	JUST BEFORE THE TERMINATOR WITH PARITY SET
;
KYTAB:	DB 019H		;INDENT
	DB 09		;TAB
	DB 05		;INSERT
	DB 03		;DELETE RUBOUTS,RELINE
	DB 0EH		;SOFT HYPHEN
ENHKEY	DB 017H		;ENHANCE MODE
	DB 04		;GLOBAL DELETE
ULKEY	DB 015H		;UNDERLINE

	DB 8		;LEFT ARROW
	DB 0CH		;RIGHT ARROW
	DB 13H		;SCAN
	DB 0AH		;DOWN ARROW
	DB 0BH		;UP ARROWN
	DB 0DH		;CR
	DB 06		;FORWARDS
	DB 02		;BACKWARDS

	DB 1BH		;BREAK
DELTKEY DB 7FH		;RUB
	DB 12H		;REPEAT
	DB 14H		;TOP LINE
	DB 18H		;MARK
	DB 01AH		;DECIMAL TAB
	DB 011H		;EDIT/COMMAND
	DB 00FH		;GLOBAL MODE

	DB 7		;PREVIOUS SCREEN
	DB 16H		;NEXT SCREEN
	DB 1		;EXTRAS
	DB 10H		;PRINTER CHARS

	DB 80H		;OR SPECIAL KEY PAD
;
;	TERMINAL TYPE TABLE - CONTAINS INFORMATION ON TERMINAL
;	SCREEN CHARACTERISTICS
;
NCNTL	EQU	13H	;LAST LEGAL CONTROL CHAR
;
SCRL	DB 24		;NUMBER OF LINES ON SCREEN
SCRW	DB 80		;CHARACTERS PER SCREEN LINE
TTYPE1	DB 0FH		;BIT MAP OF AVAILABLE TERMINAL CONTROLS
TTYPE2	DB 01H		;BIT MAPPED SCREEN FEATURES
TTYPE3	DB 4
TTYPE4	DB 0		;LEAD IN
TTYPE5	DB 0
TTYPE6	DB 0
;

CHOME:
	DB	1EH,0CH,08H
	DB	1BH,2AH,0
	DB	0BH,0,0
	DB	0AH,0,0
	DB	08H,0,0
	DB	0CH,0,0
	DB	1BH,54H,0
	DB	1BH,59H,0
	DB	1BH,'(',0
	DB	1BH,')',0
	DB	1BH,23H,0
	DB	1BH,22H,0
	DB	0DH,0,0
	DB	0DH,0AH,0
	DB	07,0,0
	DB	0,0,0
TINIT:	DB	0,0,0,0,0,0
	DB	0,0,0
XYCHR:	DB	1BH,3DH,0
XORY:	DB	1
XOFF:	DB	20H
YOFF:	DB	20H

;
;	THESE ARE THE ACTUAL I/O ROUTINES
;	YOU MAY WISH TO MODIFY THE ROUTINES
;	IN THIS SECTION TO FIT YOUR HARDWARE
;
TCPM	EQU	1	;SET TO 0 TO DIRECT TERMINAL I/O
ASCII	EQU	1	;CONVERT PRINTER TO NON-ASCII
ETXACK	EQU	0	;ETXACK PROTOCOL WITH IOS DEVICE
;

	IF TCPM		
CST:	MVI A,06H	;TERMINAL STATUS,INPUT,OUTPUT ROUTINES
	JMP CPMGO	;UNDER CP/M
CIN:	MVI A,09H
	JMP CPMGO
COUT:	MVI A,0CH
	JMP CPMGO
	ENDIF
;
	IF NOT TCPM
;	YOU MAY DEFINE YOUR OWN TERMINAL ROUTINES HERE
;
CST:	IN 0CCH		;CHECK CONSOLE STATUS
	XRI 0		;INVERT PARTS OF BIT FIELD IF NECESSARY
	ANI 1		;MASK STATUS
	RZ		;RET 0 IF NOT READY
	MVI A,0FFH
	RET
CIN:	CALL CST	;READ CONSOLE INPUT
	ORA A
	JZ CIN
	IN 0CDH
	RET
COUT:	IN 0CCH		;WRITE TO CONSOLE
	XRI 0
	ANI 2
	JZ COUT
	MOV A,C		;OUTPUT CHAR IN C REGISTER
	OUT 0CDH
	RET
	ENDIF
;
;
PROUT:	PUSH	B	;PRINT ROUTINE FOR IOS DEVICE
	MOV	C,A	;SAVE SEND CHAR
	LDA	PCOUNT	;FIRST SET ETXACK COUNTER
	INR	A
	STA	PCOUNT
	ORA	A
	JP	PROUT1	;WAIT UNTIL>128

	MOV	A,C
	ORA	A	;DON'T CHECK CHARS WITH PARITY SET
	JM	PROUT1
;
	IF	ETXACK
	MVI	A,3	;SEND ETX
	CALL	PORTOT
ETXLP:	CALL	PORTIN
	ANI	7FH
	CPI	6
	JNZ	ETXLP
	XRA	A
	STA	PCOUNT
	ENDIF

PROUT1: MOV	A,C
	CALL	PORTOT
	POP	B
	RET
;
PORTOT: JMP	SOT
PORTIN: JMP	SIN
PORTIT: JMP	SIT
;
SIT:	RET
;
SIN:	IN 0FDH		 ;DO BAUD RATE INITIALIZATION IF NEEDED
	ANI 2
	JZ SIN
	IN 0FCH
	RET
;	
SOT:	PUSH PSW	;SERIAL OUTPUT
	IN 0FDH
	ANI 1
	JZ SOT+1
	POP PSW
	OUT 0FCH
	RET
;
LSTAT:	MOV A,B
	STA DEVSEL
	ORA A
	MVI A,0FFH
	RZ
	DCR B
	MOV A,B
	CPI 4		;SET UP DEVICES 1-4
	CC DEVSET
	INR B
	MOV A,B
	CPI 10
	CNC PORTIT	;IF INTERNAL, INIT PORT
	MVI A,0FFH
	RET
;
DSTAT:	MVI D,0FFH
	LDA DRVS	;IF DRVS SET TO 0
	ORA A
	RZ		;DON'T CHECK
	MOV D,A
	MOV A,E
	ANI 0FH
	CMP D		;NUMBER SHOULD BE<NUMBER OF DRIVES
	MVI D,0FFH
	RC
	MVI D,0
	RET

RETRN:	RET		;NOT IMPLEMENTED

;	THIS ROUTINE IS FOR OUTPUT ON PRINT DEVICE #1
;	CHARACTER IN THE A REGISTER
;
SPRNT:	
	CPI 20H
	JC SCONTL
	CALL PCONVT
	CALL ALIST
	RET
;
SCONTL: 
	ORA A
	JNZ $+7
	MOV A,B
	JMP ALIST
	SUI 8
	RC
	CPI 12H
	RNC
	PUSH H
	MOV H,A
	ADD H
	ADD H
	LXI H,ATABLE
	ADD L
	MOV L,A
	JNC $+4		;FIND LOCATION OF ENTRY
	INR H
	CALL SP3
	POP H
	RET
;
SP3:	MOV A,M
	CPI 0FFH
	JNZ SOT3	;ITS DEFINED
	RET		;NOT DEFINED
SOT3:	PUSH H
	PUSH B
	MVI B,3
SOT3LP: MOV A,M
	ORA A
	CNZ ALIST
	INX H
	DCR B
	JNZ SOT3LP
	POP B
	POP H
	RET

DEVSET: PUSH B
	MOV A,B
	RAL
	RAL
	RAL
	RAL
	RAL
	RAL
	ANI 0C0H
	MOV B,A
	LDA IOBYT
	ANI 03FH
	ORA B
	STA IOBYT
	POP B
	RET
;
DEVSEL	DB 0		;ZERO FOR CP/M
;
;	ROUTINES FOR THE CP/M PRINTER, DEVICE #2
;	ALSO USED AS DEFAULT FOR PRINTERS 0 AND 1
;
CPRNT:	MOV A,C		;PRINT TO CPM FOR DEVICE #2
	ORA A		;BYPASSING NORMAL PRINTER CHANNELS
	MOV A,B
	JZ ALIST
	MOV A,C
	CPI 10H		;SUPPRESS ON/OFF SIGNALS 
	RZ		;PROVIDED BY SPELLBINDER
	CPI 0FH
	RZ
	JMP ALIST
;
ALIST:	PUSH H
	PUSH B		;PRINT A TO CPM
	MOV C,A		;TO SERVE DEVICES 0 AND 1
	CALL CPR
	POP B
	POP H
	RET
CPR:	LHLD SPOOL
	MOV A,H
	ORA L
	MOV A,C
	JZ $+4
	PCHL		;GO TO INTERNAL VECTOR

	MOV C,A
	LDA DEVSEL
	CPI 10
	MOV A,C
	JNC PROUT	;IF DEVSEL>10, SELECT IOS DEVICE
;
	MVI A,0FH	;JUMP TO CPM CBIOS LIST
	JMP CPMGO

CPMGO:	PUSH H		;ROUTINE TO JUMP TO CPM ROUTINES
	PUSH D
	PUSH B
	LXI H,CPMRET	;SET RETURN ADDRESS
	PUSH H
	MOV L,A		;LOCATE ADDRESS OF CBIOS JUMP TABLE
	LDA BASE+2	;AND APPEND THE OFFSET IN A
	MOV H,A
	PCHL		;PUT THE ADDRESS FOUND ON THE STACK
CPMRET	POP B
	POP D
	POP H
	RET
;
;
;	CONSOLE ROUTINES TIN,TST,AND TOUT CALLED SPELL BINDER
;	FOR CONSOLE INPUT,KEYBOARD READY, AND OUTPUT TO SCREEN
;
TST:	CALL CST	;CHECK CONSOLE
	ORA A		;SET FLAGS
	RET
TIN:	PUSH B		;INPUT FROM TERMINAL
	PUSH D
	PUSH H
	CALL FCIN	;READ A KEY FROM CP/M
	CPI  1FH
	JNZ $+5
	MVI A,1AH	;CHANGE NEW LINE TO CLR
	MOV B,A
	ORI 0A0H
	INR A
	JNZ TIN1	;DO DEL/RUB INVERT IF SPECIFIED IN
	LDA KTYPE1	;INPUT CONVENTIONS
	ANI 20H		;FLAG FOR INVERT DEL/RUB
	XRA B
	MOV B,A
TIN1:	MOV A,B		;RECOVER THE KEY
	CALL ESCKEY	;SEE IF THIS IS A MULTIPLE KEY
	JZ TIN2		;IF SO GO WAIT FOR THE REST
	POP H
	POP D
	POP B
	RET
TIN2:	CALL ANOTH	;WAIT FOR THE KEYS OF A MULTIPLE
	JNC TIN2	;CODE SEQUENCE UNTIL END IS SIGNALLED
	MOV C,A		;BY CARRY SET
	MOV A,D
	CPI 1		;CHECK 0,1,OR 2
	MOV A,C
	POP H
	POP D
	POP B
	RC
	JZ UCASE
LCASE:	CPI 'A'+80H
	RC
	CPI 'Z'+1+80H
	RNC
	ANI 0DFH
	ORI 20H		;SET CASE BIT
	RET
UCASE:	CPI 'A'+0A0H
	RC
	CPI 'Z'+1+0A0H
	RNC
	ANI 0DFH	;STRIP SHIFT BIT
	RET		;IF KTYPE1 BIT 1 IS SET
;
FCIN:	CALL CIN
	ORA A
	RNZ
	CALL FCSWIT
	JMP FCIN
FCSWIT: LDA FCFLG
	ORA A
	JZ FCON
FCOFF:	LDA KTYPE2
	ORA A
	RZ		;ONLY DO THIS IF FUNCTION KEYS
	MVI A,0
	STA FCFLG
	PUSH B
	MVI C,1BH
	CALL COUT
	MVI C,'K'
	CALL COUT
	POP B
	RET
FCON:	LDA KTYPE2
	ORA A
	RZ
	MVI A,0FFH
	STA FCFLG
	PUSH B
	MVI C,1BH
	CALL COUT
	MVI C,'J'
	CALL COUT
	POP B
	RET

FCFLG	DB	0
;
;	WAIT FOR ANOTHER KEY IN A MULTIPLE
;	KEY SEQUENCE.  DELAY FOR ABOUT 7 MS.

ANOTH:	MOV C,A		;SAVE THE LAST CHAR
	LXI H,28	;WAIT A SHORT TIME FOR COMPLETION
TINLP:	CALL CST
	ORA A
	JNZ TIN1OT	;CHARACTER HIT IN TIME
	CALL WAIT1	;125 US. DELAY
	DCX H
	MOV A,L
	ORA H
	JNZ TINLP
	MOV A,C		;RESTORE LAST CHAR
	STC		;RET CARRY WHEN TIME OUT
	RET
TIN1OT: MOV A,B
	ORA A
	JZ $+6
	JP TIN2OT
	CALL CIN	;READ THE NEXT CHAR
	ORI 80H
	CMP B		;SEE IF IT MATCHES THE TERMINATOR
	STC
	CMC		;IF NOT, SEND KEY BACK, NO CARRY
	RNZ
	MOV A,C		;IF A TERMINATOR, USE THE CHAR BEFORE
	STC		;SIGNAL DONE
	RET
TIN2OT: CALL CIN
	ORI 80H
	DCR B
	STC
	RZ		;SEQUENCE DONE?
	CMC
	RET
;
;	IF KEY INPUT MATCHES ONE OF THE MULTIPLE
;	KEYS LEADS, RET ZERO SET AND THE
;	SEQUENCE TERMINATOR IN B
;
ESCKEY: MOV C,A		;SAVE ORIGINAL CHARACTER
	LDA KTYPE3	;TERMINATOR FOR SEQUENCE
	XRI 80H
	MOV B,A		;RETURNED IN B
	LDA KTYPE1
	ANI 1		;UPPER ONLY?
	MOV D,A
	LDA KTYPE2	;RET ZERO IF A MATCH
	CMP C
	RZ
	LDA KTYPE5	;TERMINATOR FOR SECOND
	XRI 80H
	MOV B,A
	LDA KTYPE1
	RAL
	ANI 2		;LOWER CASE ONLY
	MOV D,A
	LDA KTYPE4	;TRY A SECOND
	CMP C
	MOV A,C		;RESTORE ORIGINAL CHAR
	RET
TOUT:	PUSH B		;OUTPUT A REG TO TERMINAL
	MOV C,A
	CALL COUT
	POP B
	RET
INT:	CALL STARTUP	;STARTUP CONFIGURATION EXECUTION
	CALL FCON
	LXI H,TINIT
	MVI B,6
	CALL HLTER
	MVI A,8
	CALL SERA
	MVI A,1		;CLEAR SCREEN
	CALL SERA
	MVI C,0FFH
	CALL HHAND
	LDA TTYPE2
	ANI 0CH	       ;SEE IF ANY ENHANCE
	RNZ
	STA ENHKEY
	STA ULKEY
	RET

EXIT:	CALL FCOFF
	MVI C,0		;SO A BDOS EXIT
	CALL DOS
	JMP BASE

;
;
;	HARDWARE INDEPENDENT ROUTINES FOR A SERIAL TERMINAL
;	DEFINE UP TO 3 BYTE SEQUENCE FOR TERMINAL CONTROL
;	OF EACH FUNCTION
;
TERM:	CPI 20H
	JC SERC		;CHECK FOR CONTROL CODES FROM SB
	PUSH B
	MOV B,A
	CALL ULCHK
	CALL ENCHK	;ENHANCE CHECK FOR CHAR ENHANCE TERMS
	MOV A,B
	POP B
	RC		;MEANS DON'T PRINT

	ANI 7FH
	CPI 7FH		;REPLACE RUBOUT SINCE IT WON'T SHOW
	JNZ $+5
	MVI A,05CH	;USE BACKSLASH FOR RUBOUT
	CPI 7EH		;REPLACE TILDA WITH BACK APOSTROPHE
	CZ TILDA	;FOR HAZELTINE
	PUSH PSW
	CALL CCBMP	;KEEP COUNT FOR SCREEN HANDLERS
	POP PSW
	JMP TOUT	;NOW OUTPUT TO THE TERMINAL
TILDA:	LDA TTYPE2
	ANI 2
	MVI A,7EH
	RZ
	MVI A,'`'	;REPLACE TILDA FOR HAZELTINE
	RET    
;
;	ENCHK TURNS ENHANCEMENT ON/OFF
;	WITH CHARACTER ENHANCE TERMINALS
;
ENCHK:	
;	LDA TTYPE2
;	ANI 30H
;	RNZ
	LDA ENFLG	;CHECK CURRENT STATE OF ENHANCE
	XRA B
	RAL
	RNC		;NC IF PARITY SAME AS BEFORE
	MOV A,B		;ELSE SET TO STATE OF THIS CHAR
	RAL
	JC EHON		;ON
	JMP EHOFF	;OR OFF
;
ULCHK:	MOV A,B		;REPLACE ENHANCED SPACES
	CPI 0A0H	;WITH ENHANCED UNDERLINES
	RNZ		;IF TERMINAL REQUIRES IT
	LDA TTYPE2
	ANI 4		;CAN TERM ENHANCE ALL CHARS?
	RNZ		;OR ONLY NON-SPACES?
	MVI B,0DFH	;USE AN ENHANCED UNDERLINE
	RET
EHOFF:	MVI A,8		;TURN ENHANCE OFF
	CALL SERC1
	STC		;ELIMINATE THIS CHAR
	RET
EHON:	MVI A,4		;BACKSPACE
	CALL SERC1
	MVI A,9		;TURN ENHANCE ON
	CALL SERC1
	RET
ENFLG	DB	0
;
CLRLIN: LDA	TTYPE1	;CHECK FOR CLEOL
	ANI	4
	RNZ
	PUSH	B	;HANDLE CLEAR EOL FOR TERMS WITHOUT THIS FUNCTION
	LDA	CCOUNT	;GET THE COLUMN COUNT
	MOV	B,A
	LDA	SCRW
	SUB	B
	MOV	B,A
	LDA	SCRL
	MOV	C,A
	LDA	HSCRL
	ADD	C
	MOV	C,A
	LDA	LCOUNT
	INR	A
	SUB	C
	JNZ	CLRLLP
	DCR	B	;ONE LESS ON LAST LINE

CLRLLP	MOV	A,B
	ORA	A
	MVI	A,20H
	CNZ	TOUT
	DCR	B
	JNZ	CLRLLP
	LDA	CCOUNT
	MOV	C,A
	LDA	LCOUNT
	MOV	B,A
	CALL	TERMXY
	POP	B
	RET

CCBMP:	PUSH	B
	LDA	CCOUNT
	INR	A
	STA	CCOUNT
	MOV	B,A
	LDA	SCRW
	SUB	B
	POP	B
	RNZ		;RET UNLESS THE LAST CHARE ON LINE
	MVI	A,0	;UNLESS ON THE LAST LINE
	STA	CCOUNT
LCBMP:	PUSH	B
	LDA	SCRL
	MOV	B,A
	LDA	HSCRL
	ADD	B
	MOV	B,A	;GET TOTAL SCREEN LENGTH IN B
	LDA	LCOUNT
	CMP	B
	POP	B
	RZ		;DON'T BUMP IF LAST LINE
	LDA	LCOUNT
	INR	A
	STA	LCOUNT
	RET

LCBAK	LDA	LCOUNT
	ORA	A
	RZ
	DCR	A
	STA	LCOUNT
	RET

CCBAK	LDA	CCOUNT
	DCR	A
	STA	CCOUNT
	RNC
	PUSH	B
	LDA	LCOUNT
	DCR	A
	STA	LCOUNT
	LDA	SCRW
	STA	CCOUNT
	RET
	
LCZERO	MVI	A,0
	STA	LCOUNT
	STA	CCOUNT
	RET

LCCHK:	CPI	1
	JZ	LCZERO
	CPI	0
	JZ	LCZERO
	CPI	2
	JZ	LCBAK
	CPI	4
	JZ	CCBAK
	CPI	3
	JZ	LCBMP	;BUMP LINE NUMBER
	CPI	5
	JZ	CCBMP
	CPI	0CH
	JZ	CZERO
	CPI	0DH
	RNZ
	CALL	LCBMP

CZERO:	MVI	A,0
	STA	CCOUNT
	RET

CCOUNT: DB	0
LCOUNT: DB	0

;	SEND CONTROL CODES TO THE SCREEN
;
SERC:	CPI NCNTL+1
	RNC
	CPI	8		;REJECT ENHANCE ON AND OFF
	RZ
	CPI	9
	RZ
SERC1:	PUSH H
	PUSH B
	MOV C,A
	CALL LCCHK
	MOV A,C
	LXI H,CHOME-3  ;START OF TABLE-1 ENTRY
TTLP:	INX H	  ;GET THE ENTRY INDEXED BY A
	INX H
	INX H
	DCR A
	JP TTLP
	MOV A,C	       ;IF INIT, SEND NINE
	MVI B,3	       ;ELSE SEND THREE CODES
	CALL HLTER     ;OUTPUT TO TERMINAL
	MOV A,C
;	CPI 0	       ;TURN OFF ENHANCE ON CLEAR,HOME
;	CZ EHOFF
	MOV A,C
	CPI 1
	JNZ SERC6
;	CALL EHOFF
	LDA TTYPE3
	CALL WAIT
SERC6:	MOV A,C		;WAIT 2 NULLS FOR CLEOL
	CPI 6
	JNZ SERC7
	LDA TTYPE3
	CALL WAIT8TH
SERC7:	MOV A,C
	CPI 7
	JNZ SERC8
	LDA TTYPE3
	CALL WAIT
SERC8:	MOV A,C		;SET ENHANCE FLAG FOR ENHANCE
	CPI 8		;ON/OFF COMMANDS
	JNZ SERC9
	MVI A,0
	STA ENFLG
SERC9:	CPI 9
	JNZ SERCD
	MVI A,80H
	STA ENFLG
SERCD:	POP B
	POP H
	CPI 6		;CLEOL
	JZ  CLRLIN	;CALL SPACE CLEAR FUNCTION
	CPI 0DH
	RNZ
	LDA TTYPE2	;IF SIDESPACE ENHANCE
	ANI 10H		;SEND A FWD SPACE
	RZ		;TO MAKE ROOM FOR EH CONTROL
	MVI A,5
	JMP SERC

WAIT:	PUSH B		;wait (A) MS.
	MOV B,A
	MVI C,8
	MOV A,B
	CALL WAIT8TH
	DCR C
	JNZ $-5
	POP B
	RET

WAIT8TH ORA A		;WAIT (A) X 125 US.
	RZ
	CALL WAIT1
	DCR A
	JMP WAIT8TH

WAIT1:	PUSH PSW	;WAIT 125 US.
	PUSH H
	LDA SPEED	;GET SYSTEM SPEED VARIABLE
	ORA A
	RAR		;DIVIDE BY 2 TO GET DELAY TIME
	MOV L,A		;FOR 125 US.
	MVI H,0
	DCX H
	MOV A,L
	ORA H
	JNZ $-3
	POP H
	POP PSW
	RET
HLTER:	MOV A,M		;SEND SEQUENCE IN HL
	ORA A
	CNZ HLTOUT
	INX H
	DCR B
	JNZ HLTER
	RET
;
HLTOUT: ORA A
	JP TOUT
	ANI 7FH
	CPI 20H
	JC SERC
	PUSH PSW
	LDA TTYPE4	;SEND LEAD IN
	ORA A
	CNZ TOUT
	POP PSW
	JMP TOUT
TERMXY: PUSH H		;SET CURSOR ON ROW (B), COLUMN (C)
	MOV A,B
	STA LCOUNT
	MOV A,C
	STA CCOUNT
	LDA TTYPE3
	CALL WAIT8TH
	LXI H, XYCHR	;SEND CURSOR POSITION CODE
	PUSH B
	MVI B,3
	CALL HLTER
	POP B
	POP H
	LDA XORY	;SEE IF X OR Y FIRST
	ORA A
	CNZ YFIRST
	LDA XOFF	;ADD OFFSET
	ADD C
	CALL TOUT
	LDA XORY
	ORA A
	RNZ
YFIRST: LDA YOFF
	ADD B
	CALL TOUT
	RET
;
;
ARD:
AWT:	MVI D,0FFH
	RET
;
;XX
;	LOCATION FOR PRINT ROUTINES
;	ROUTINES TO TRANSMIT AND DO BUFFER CHECK
;	FOR DIABLO,QUME, OR NECWRITER
;
;	ROUTINES DOES AN EOT/ACK SEQUENCE AFTER EACH
;	128 CHARACTERS TO PREVENT BUFFER OVERRUN
;
;
XMIT:	ORI 80H		;SET PARITY TO DISALLOW ETXACK
XMITP:	CALL ALIST	;OUTPUT TO PRINTER
	RET
;
;	ROUTINES FOR THE NECWRITER 5510,DIABLO 1610
;	AND QUME SPRINT 5.
;
;	SEE SPELLBINDER TECHNICAL MANUAL ON INFORMATION ON
;	INTERFACING OTHER 120TH INCH RESOLUTION PRINTERS
;
;	UCOUT: PRINT A CHARACTER
;
UCOUT:	CPI 21H		;SEND A CHARACTER
	JC CONTRL	;SEND RIGHT AWAY IF A CONTROL
	STA KSAVE	;ELSE BUFFER AND WAIT FOR NEXT CARRIAGE
	RET		;MOVEMENT COMMAND
CONTRL: 


CONTR1: 
	ORA A
	JNZ $+6
	MOV A,B
	ANI 7FH
	PUSH H		;FIRST PRINT ANY CHAR IN THE BUFFER
	PUSH PSW
	LXI H,0		;WITH A ZERO VMI
	CALL UCARR
	POP PSW
	POP H
	CPI RETURN	;IF A RETURN, ZERO ACCUMULATOR
	JNZ XMIT	;FOR CARRIAGE POSITION
	XRA A
	STA ACCUM
	STA ACCUM+1
	MVI A,RETURN
	JMP XMIT	;AND SEND RETURN CODE
;
;	UCARR: PERFORM CARRIAGE MOVE IN HL, TWO'S COMP
;
UCARR:	PUSH H
	PUSH D
	PUSH B
	CALL CDIRCT	;CHECK DIRECTION
	CALL TABCK	;SEE IF MOVE > LARGEST AVAILABLE
	XCHG
	LHLD ACCUM	;UPDATE THE COUNTER WHICH KEEPS
	DAD D		;THE ABSOLUTE POSITION OF THE CARRIAGE
	SHLD ACCUM
	XCHG
	CALL ABSHL	;MAKE POSITIVE
	CALL UPF1	;MOVE CARRIAGE
	POP B
	POP D
	POP H
	RET
UPF1:	MOV A,H
	ORA A
	JNZ MOSTLP
	LDA MOST
	CMP L
	JNC MCAR1
MOSTLP: PUSH D
	XCHG
	LDA MOST
	MOV L,A
	CALL MCAR1
	MOV A,E
	SUB L
	MOV E,A
	JNC $+4
	DCR D
	XCHG
	POP D
	JMP UPF1
;
MCAR1:	LDA HINC	;GET CURRENT HMI
	CMP L
	JZ SCHAR	;IF THE SAME AS BEFORE, DONT CHANGE
MCAR:	LDA HMI		;SEND HMI SEQUENCE
	CALL PSEND	;SEND ESCAPE CODE
	MOV A,L
	STA HINC	;KEEP RECORD OF HMI
	LDA HMIOFF	;NECWRITER USES '@'+ INC
	ADD L
	CALL XMIT	;SEND THE NEW HMI
SCHAR:	LDA HINC	;ONLY SEND IF A CARRIAGE MOVEMENT
	ORA A		;OR A CHARACTER TO SEND
	LDA KSAVE
	JNZ $+6
	CPI 20H
	RZ		;DON'T SEND SPACE IF NO MOVEMENT
;
	CALL PCONVT	;CONVERT FOR NON-ASCII WHEELS
	CALL XMITP
	MVI A,20H	;ZERO THE CHARACTER BUFFER
	STA KSAVE
	RET
CDIRCT: LDA DIRCT	;GET THE LAST DIRECTION
	XRA H		;SEE IF SIGN MATCHES
	RP		;LAST BIT ZERO IF MATCH
	LDA DIRCT	;ELSE CHANGE DIRECTION
	CMA
	STA DIRCT
	ORA A
	LDA RIGHT
	JP $+6
	LDA LEFT
	CALL PSEND
	RET

PCONVT: 
	IF ASCII
	RET
	ENDIF

	IF NOT ASCII
	PUSH B
	MOV B,A
	LDA FFLG
	ORA A
	MOV A,B
	POP B
	RZ		;IF FFLG NOT SET, JUST RETURN
	PUSH H
	LXI H,TABLE-20H 
	ADD L
	MOV L,A
	JNC $+4
	INR H
	LDA SHFLG
	XRA M
	CM CSHFT
	MOV A,M
	ANI 7FH
	POP H
	RET

CSHFT:	LDA SHFLG
	CMA
	STA SHFLG
	ORA A
	JNZ SHOUT

SHIN:	XRA A
	STA SHFLG
	MVI A,15
	CALL XMIT
	RET
SHOUT:	MVI A,0FFH
	STA SHFLG
	MVI A,14
	CALL XMIT
	RET

SHFLG	DB	0

	ENDIF

;	IF PRINTER CANNOT PERFORM THE MOVE IN HL
;	USING A HORIZONTAL INCREMENT, THE CARRIAGE
;	IS TABBED AS CLOSE TO THE DESIRED POSITION
;	AS POSSIBLE, AND THE REMAINDER PUT IN HL
;
;
TABCK:	PUSH H		;SEE IF A TAB IS NEEDED FOR
	CALL ABSHL	;THE CARRIAGE MOVE IN HL
	MOV A,H		;IF NEEDED, PERFORM TAB
	ORA A		;AND RETURN WITH HL=NEW MOVEMENT NEEDED
	JNZ TABCON
	LDA MOST	;OK IF LESS THAN OR EQUAL TO GREATEST
	CMP L		;VMI POSSIBLE
	MOV A,L
	POP H
	RNC
	PUSH B
	MOV B,A		;GET THE SIZE OF THE MOVE
	LDA HINC
	ORA A
	ADD A		;SEE IF GREATER THAN 2 TIMES
	CMP B		;THE CURRENT VMI
	POP B
	JNC SPCON	;USE SPACES IF IT IS
	PUSH H
TABCON: POP H		;TAB TO NEAR THE DESIRED POSITION
	LDA TAB		;SEE IF TAB DEFINED
	ORA A
	RZ
	XCHG
	LHLD ACCUM	;GET CURRENT POSITION
	DAD D		;CALC ABSOLUTE POSITION REQUIRED
	MVI C,12	;FIND TAB IN 12/120THS
	CALL DVHLC	;TAB POSITION IN L
	MOV C,B		;PUT REMAINDER IN BC
	MVI B,0
	MOV A,C
	ORA A
	JZ TDON		;COMES OUT EVEN ON TAB?
	LDA DIRCT
	ORA A
	JP TDON		;IF FORWARD TAB, GO TO LEFT OF MARK
	INR L		;ELSE UP TAB ONE TO LAND ON RIGHT
	MOV A,C		;THEN SET REMAINDER SLIGHTLY NEGATIVE
	SUI 12
	MOV C,A
	DCR B		;THIS PUTS A NEG NUMBER IN BC
TDON:	PUSH H
	LXI H,12	;FIRST SET UP 10 PITCH
	CALL MCAR	;AND PRINT THE EXISTING CHAR
	POP H
	MOV A,L
	PUSH PSW	;SAVE THE TAB
	DAD H		;CALCULATE NEW POSITION = 12XTAB
	DAD H
	PUSH H
	POP D		;4X IN DE
	DAD D		;8X IN HL
	DAD D		;12X IN HL
	SHLD ACCUM	;UPDATE TO NEW CARRIAGE POSITION
	MOV H,B		;PUT REMAINING MOVEMENT IN HL
	MOV L,C
	POP PSW
	MOV B,A		;TAB TO LOCATION IN B
	SUI MXTAB
	JC TABOT	;IF TAB <= MAX, WERE OK
	JZ TABOT
	PUSH PSW	;SAVE EXTRA PAST MXTAB
	MVI B,MXTAB
	CALL TABOT
	POP PSW
	MOV B,A
	MVI A,20H
	CALL XMIT
	DCR B
	JNZ $-6
	RET
MXTAB	EQU	120
TABOT:	LDA PNUMB
	CPI 3
	JZ NTAB		;IF A NECWRITER, USE NTAB
	LDA TAB		;SEND TAB COMMAND
	CALL PSEND
	LDA TABOFF	;NOW DO THE TAB
	ADD B		;ADD TAB TO OFFSET
	CALL XMIT
	RET
NTAB:	MOV A,B		;TAB FOR THE NEC PRINTER
	RRC
	RRC
	RRC
	RRC
	RRC
	ANI 7		;FIRST CHOOSE P,Q,R,S,OR T
	ADI 'P'
	CALL ESC
	MOV A,B
	ANI 1FH
	ADI '@'
	CALL XMIT
	RET
SPCON:	PUSH D		;SPACE ONE HMI IN THE DIRECTION
	PUSH H		;THE PRINTER IS GOING
	LDA HINC
	MOV L,A
	MVI H,0
	LDA DIRCT
	ORA A
	CM COMPH
	MOV D,H		;SAVE MOTION
	MOV E,L
	CALL UCARR
	XCHG
	CALL COMPH	;SUBTRACT OFF FROM THE MOVE
	XCHG		;REQUESTED
	POP H		;RETURN REMAINDER OF MOTION IN HL
	DAD D
	POP D
	RET
;
;	UROLL: MOVE THE CARRIAGE UP OR DOWN
;
UROLL:	PUSH H
	LXI H,0		;SET HMI TO ZERO FOR VERTICAL MOVE
	CALL UCARR	;ALSO PRINTS ANY CHAR IN BUFFER
	POP H
	PUSH H
	CALL ABSHL
	LDA VINC	;SEE IF INCREMENT NEEDS TO BE CHANGED
	CMP L		;ASSUME ONE BYTE VALUE
	JZ FEED
	LDA VMI
	CALL PSEND
	MOV A,L
	STA VINC
	LDA VMIOFF     ;FOR VMI
	ADD L
	CALL XMIT
FEED:	POP H
	MOV A,H
	ORA A
	LDA REVLF      ;REVERSE LF
	JM PSEND
	LDA FORLF
	CALL PSEND
	RET
PSEND:	ORA A
	JP XMIT
	ANI 7FH
ESC:	PUSH PSW	;SEND AN ESCAPE CHARACTER
	MVI A,1BH
	CALL XMIT
	POP PSW
	JMP XMIT
;
;	UREST: RESTORE PRINTER TO STARTUP CONDITION
;
UREST:	XRA A		;INIT INCREMENTS
	STA PCOUNT	;COUNTER FOR PRINTER BUFFER
	STA VINC
	STA HINC
	MVI A,20H	;ZERO PRINTER BUFF
	STA KSAVE
	CALL UOFF
	RET
;
;	UOFF: TURN OFF THE PRINTER
;
UOFF:	PUSH H
	MVI A,RETURN	;EXECUTE A CRLF TO START
	CALL UCOUT
	XRA A		;AND START OFF FORWARD
	STA DIRCT
	LXI H,RESET	;SEND PRINTER RESET CODES
UOFFLP	MOV A,M
	CALL XMIT
	INX H
	MOV A,M
	ORA A
	JNZ UOFFLP
	POP H
	RET
;
;	ARITHMETIC ROUTINES
;
DVHLC:	PUSH D		;DIVIDE HL BY C
	LXI D,0FFFFH
	INR H
DVLP:	INX D
	MOV A,L
	SUB C
	MOV L,A
	JNC DVLP
	DCR H
	JNZ DVLP
	XCHG		;RESULT IN HL
	MOV A,E
	ADD C
	MOV B,A		;REMAINDER IN B
	POP D
	RET
ABSHL:	MOV A,H		;ABSOLUTE VALUE OF HL
	ORA A
	RP
COMPH:	MOV A,H		;TWO'S COMPLEMENT HL
	CMA
	MOV H,A
	MOV A,L
	CMA
	MOV L,A
	INX H
	RET
;
PCOUNT	DS 1
VINC	DS 1
HINC	DS 1
KSAVE	DB 20H
DIRCT	DB 0
ACCUM	DW 0
;
;	PRINTER CONTROL TABLE
;	BIT SET CAUSES ESC TO BE PREFACED
;
PNUMB	DB	1
HMI	DB	1FH+80H
HMIOFF	DB	1
VMI	DB	1EH+80H
VMIOFF	DB	1
LEFT	DB	'6'+80H
RIGHT	DB	'5'+80H
FORLF	DB	0AH
REVLF	DB	0AH+80H
MOST	DB	120
TAB	DB	89H
TABOFF	DB	1
RESET	DB	0DH,1BH,1FH,0DH,1BH,1EH,7,0,0
RETURN	EQU	0DH


;	PRINTER TABLE TO EXCLAMATION COMMANDS FROM SPELLBINDER
;	THE RED AND BLACK ENTRIES ARE INITIALIZED FROM
;	THE QUME,HYTYPE AN NEC TABLES
;
;	THE REST ARE USER DEFINABLE
;
;
PTABLE	EQU $

;	TABLE FOR ! CONTROLS

	DB	1BH,41H,0	;q  Enhance 1 on
	DB	1BH,42H,0	;r  Enhance 1 off
	DB	1BH,75H,'G'	;s  Enhance 2 on
	DB	1BH,75H,'@'	;t  Enhance 2 off

	DB	0,0,0		;u    u-z are free for user
	DB	0,0,0		;v
	DB	0,0,0		;w
	DB	0,0,0		;x
	DB	0,0,0		;y
	DB	'T','S','T'	;z FOR TEST,BUT YOU CAN ALTER
;
;	TABLE FOR ASCII PRINTER
;
ATABLE	EQU	$

	DB	08H,0,0		;BACK SPACE
	DB	09H,0,0		;HALF SPACE
	DB	0AH,0,0		;LINE FEED
	DB	1BH,0AH,0	;NEG LF
	DB	0CH,0,0		;FORM FEED
	DB	0DH,0,0		;CARRIAGE RETURN
	DB	0,0,0		;
	DB	0,0,0		;RESET OFF
	DB	0,0,0		;RESET ON
	DB	0,0,0		;HALF LF
	DB	0,0,0		;HALF NEG LF
	DB	0,0,0		;BOLD ON
	DB	0,0,0		;BOLD OFF
	DB	0,0,0		;
	DB	0,0,0		;
	DB	0,0,0		;

SHTIN:	DB	0FH,0,0		;SHIFT IN
SHTOUT: DB	0EH,0,0		;SHIFT OUT
;
;
;	FONT CHANGE TABLE
;
	DB	0,0,0		;FONT 1
	DB	0,0,0		;FONT 2
	DB	0,0,0		;FONT 3
	DB	0,0,0		;FONT 4
	DB	0,0,0		;FONT 5

	DB	0,0,0		;spacing 1
	DB	0,0,0		;spacing 2
	DB	0,0,0		;spacing 3
	DB	0,0,0		;spacing 4
;
	IF ASCII
;
SHMRK:	DB	0
FFLG	DB	0
;
	ENDIF

	IF NOT ASCII
;
SHMRK:	DB	99H
FFLG	DB	0
TABLE:
	DB	020H,04BH,022H,03DH,07AH,0CBH,03CH,04FH
	DB	06EH,047H,02AH,034H,0D1H,024H,033H,074H
	DB	0C9H,0C3H,0D0H,0CDH,0C1H,0D4H,0C5H,0CFH
	DB	0D2H,0D3H,071H,066H,055H,037H,076H,053H
	DB	05EH,02FH,04DH,036H,04AH,03FH,021H,05AH
	DB	077H,057H,065H,052H,04EH,043H,046H,0D8H
	DB	044H,0D9H,023H,042H,025H,040H,028H,041H
	DB	07BH,048H,05BH,035H,038H,0DCH,07CH,0DBH
	DB	02CH,0C8H,064H,078H,03BH,0CEH,026H,06BH
	DB	0C2H,0CAH,06CH,061H,067H,075H,0CCH,0D5H
	DB	073H,079H,03AH,0C7H,0D7H,062H,072H,06FH
	DB	069H,06DH,068H,02DH,060H,02EH,030H,07FH

;
	ENDIF

;
HHAND:	LDA HSCRL
	ORA A
	RZ		;NO HELP MESSAGES
	MOV A,C
	INR A
	CPI HPNUM+1
	RNC
	PUSH B
	PUSH H
	LXI H,IMSG	;SEND HELP MESSAGE (C) TO SCREEN
	INR C
HHLP1:	DCR C
	JM HHLP3
HHLP2:	MOV A,M
	INX H
	ORA A
	JNZ HHLP2
	JMP HHLP1
HHLP3:	MOV A,M
	ORA A
	JZ HHDN
	INX H
	CALL TERM
	JMP HHLP3
HHDN:	POP H
	POP B
	RET
;
;XX
;
;
STARTUP: JMP START0
;
;	HELP MESSAGE AND CONFIGURATION AREA
;	MAY BE DISCARDED OR KEPT BY PROGRAM
;
;	HELP MESSAGES MAY BE ALTERED TO SUIT YOUR
;	TERMINAL, BUT THEY MUST BE KEPT TO THE LENGTH
;	OF ONE LESS THAN THE TERMINAL LINE LENGTH
;
HLENG	EQU	3	;LENGTH OF HELP MESSAGE
HPNUM	EQU	41
NONE	DB 0
;
IMSG:	DB 0
HMSG0:
   DB 6
  DB ' '
  DB ''
  DB 0DH,06H
  DB '   insert(^E)   indent(^Y)   cursor(^H^J^K^'
  db 'L^S)   clear(^C)   (^Q)      '
  DB 0DH,6
  DB '    change(^O) forw(^F) back(^B) delt'
  db '(^D) enhance(^U)    (ESC)      '
  DB 0
HMSG1:		
  DB 0DH,6
  DB '   H old  T op  E nd  N ext  P rev page'
  DB '  I ndent clr  B ack  F orw '
  DB 0DH,6
  DB 0
HMSG2:		
	DB 6
	DB ' '
	DB ''

	DB 0DH,6
	DB '  1: Disk  2: Search  3: Move/Delete  '
	DB '4: Print  5: Tables  Exit(X)  Help(HE)'

	DB 0DH,6
	DB 0
HMSG3:		
	DB 0DH
	DB 6	
	DB ' directory(Q)     get edit file(G)  '
	DB 'edit done/save file(GD)   quit edit(GQ)'
	DB 0DH,6
	DB 6
	DB ' delete file(QD)  read a file(R)    '
	DB 'read done(RD)'
	DB 0
HMSG4:		
	DB 0DH
	DB 6	
	DB ' Search and Replace:  n instances(Sn)  '
	DB 'all instances(SA)  search disk file(SG)'
	DB 0
HMSG5:		
	DB 0DH
	DB 6	
	DB ' delete n lines(Dn)  delete all text(DA)'
	DB '  hold n lines(Hn)  dump hold(U)'
	DB 0
HMSG6:		
	DB 0DH
	DB 6	
	DB ' print(P)  reset(PR)  form feed(FF)  screen'
	DB ' print(V)  print formats(Y,YT)'
	DB 0
HMSG7:		
	DB 0DH
	DB 6	
	DB ' status(ST)  tabs(Z)  print format(Y)'
	DB '  titling(YT)  dump formats(FY,FT,FH)'
	DB 0
TABMSG:
	DB 0DH
	DB 'To set or clear, position cursor and hit "TAB"',0DH
	DB '"CLEAR" or control C clears all tabs',0DH
	DB '"TAB" followed by 0-9 sets uniform tab stops',0DH
	DB '"RETURN" to exit',0
HELPMSG:
	DB 0DH,0DH,0DH
	DB 'Type "HELP" for help menu',0
SRCHMSG:
	DB 0DH,6
	DB ' begin search string with * to ignore capitalized/enhanced'
	DB 0DH,6
	DB ' begin search string with ! for  search/replace'
	DB 0

DSKMSG:
	DB 0DH,6
	DB '   Enter the filename, or RETURN if read or write is not needed'
	DB 0

YTMSG:	DB 'FORMAT           Examples:'
	DB 0DH
	DB '30 title right/page left   23 title center/page right'
	DB 0DH
	DB '03 title left/page right   32 title right/page center'
	DB 0

	DB 0


	DB 0

HMSG15: DB 'precision(0)  dot matrix(1)  system(2)',0
HMSG16: DB 'default printer(0)',0
HMSG17: DB 'line oriented(0)  char oriented(1)',0
HMSG18: DB 'length of printed text (90 = 9 in.)',0
HMSG19: DB 'length of paper (110 = 11 in.)',0
HMSG20: DB 'stop each page(0)  space(1)  form feed(2)',0
HMSG21: DB 'indent from left margin in tenths',0
HMSG22: DB 'single space(1)  double(2)  triple(3)',0
HMSG23: DB 'left(0) right just(1) center(2) right(3)',0
HMSG24: DB 'print width (65 = 6.5 in)',0
HMSG25: DB '6 per inch(2)  8 per inch(3)',0
HMSG26: DB 'pica(1)  elite(2)',0
HMSG27: DB 'shadow(0)  underline(1)  bold(4)',0
HMSG28: DB 'fixed pitch(0) proportional(1)',0
HMSG29: DB 'set for hyphenation check',0
HMSG30: DB 0
HMSG31: DB 'none(0) titling(1) paging(2) both(3)',0
HMSG32: DB 'empty lines between title & text',0
HMSG33: DB 'none(0) titling(1) paging(2) both(3)',0
HMSG34: DB 'empty lines between title & text',0
HMSG35: DB 'two digits (XY) place title&page numbers',0
HMSG36: DB 'X/Y = 0:left 2:center 3:right',0
HMSG37	DB 0
HMSG38: DB 'left margin of page in tenths',0
HMSG39: DB 0
HMSG40: DB 'set for sheet feeders',0

HMSGE	EQU	$
;
;
;	CONFIGURATION CODE
;	THIS CODE IS THROWN AWAY UPON ENTRY TO SPELLBINDER
;
START0: 
	LXI H,PTABS
	LXI D,KTYPE1
	MVI B,TTLENG+KTLENG
	PUSH H
	LXI H,TMSG0	;GET THE KEYBOARD STYLE
	CALL MSGR
	CALL RDA
	POP H
	SUI 1		;1 MEANS USE KEYPAD
	JZ S2
	MVI A,KTLENG	;ELSE USE THE CONTROL
	INX H		;KEYS ALREADY IN TABLE
	INX D
	DCR B
	DCR A
	JNZ $-4
S2:	MOV A,M		;NOW MOVE TERMINAL TABLE
	STAX D
	INX H		;INTO PLACE
	INX D
	DCR B
	JNZ $-5

	LDA KTYPE2
	ORA A
	JZ NOKEYS
	LXI D,HMSG0	;IF FUNCTION KEYS, USE THOSE MESSAGES.
	LXI H,KMSG0
HMSLP:	MOV A,M
	STAX D
	INX H
	INX D
	ORA A
	JNZ HMSLP
;
NOKEYS:
	LXI H,TMSG6	;ASK FOR THE TYPE OF PRECISION PRINTER
	CALL MSGR
	CALL RDA
	SUI 1		;ANSWER 0 MEANS NO CHANGE
	CPI 3		;MUST BE NEC,QUME,DIABLO
	JNC START3
	LXI H,HTABLE-PTLENG
	LXI D,PTLENG
	DAD D
	DCR A
	JP $-2
	LXI D,PNUMB	;MOVE PRINTER TAB INTO PLACE
	MVI B,PTLENG
	MOV A,M
	STAX D
	INX H
	INX D
	DCR B
	JNZ $-5
START3: LXI H,TMSG5	;HELP MESSAGES?
	CALL MSGR
	CALL RDYN
	SUI 'Y' 
	STA HSCRL	;IF ZERO, SET UP HELP MESSAGES
	LXI H,TMSG3
	CALL MSGR
	LDA HSCRL
	ORA A
	LXI H,HMSGE+4
	JZ SSIZE
	LXI H,HMSG1+4	;SET START OF TEXT ON HELP MESSAGES
SSIZE:	INR H		;SET UP THE END OF MEMORY PARAMETER
	MVI L,0
	SHLD TXADR
	MOV A,H
	LXI H,BASE
	SUB H
	DCR A
	MOV B,A		;LENGTH OF PROGRAM
	MVI C,0
SZLP:	MOV A,B
	SUI 100
	JC SZ2
	MOV B,A
	MVI A,'1'
	CALL TOUT
SZ2:	MOV A,B		;OUTPUT A MESSAGE ABOUT
	SUI 10		;LENGTH OF CONFIGURED PROGRAM
	JC $+8
	INR C
	MOV B,A
	JMP SZLP
	MOV A,C
	ADI '0'
	CALL TOUT
	MOV A,B
	ADI '0'
	CALL TOUT
	LXI H,TMSG4	;ASK FOR OK ON CONFIGURATION
	CALL MSGR
	CALL CIN
	ANI 5FH
	CPI 1BH		;ESCAPE TO START OVER
	JZ STARTUP
;
;	COMPLETE CONFIGURATION
;
	MVI A,0C9H
	STA STARTUP	;BLOCK OUT STARTUP
	CALL HSET	;SET UP HELPS
	LDA TTYPE2	;SET UP FOR TERMINALS WITH
	ANI 10H		;ENHANCEMENT WHICH TAKES
	RZ		;SPACE ON THE SCREEN
	LDA SCRW
	SUI 3		;TAKE TWO FROM SCREEN WIDTH
	STA SCRW
	LDA TTYPE1	;FORCE CRLF AT END OF EACH LINE
	ANI 0F7H
	STA TTYPE1
	LDA XOFF	;MAKE A SPACE AT START OF EACH LINE
	INR A		;FOR ENHANCEMENT CHARACTER
	STA XOFF
	RET
HSET:	LDA HSCRL	;SEE IF HELPS ARE REQUESTED
	ORA A
	JNZ NOHELP
	MVI A,HLENG	;SET UP FOR HELPS
	STA HSCRL
	MOV B,A
	MVI A,0FFH
	STA HSFLG
	LDA SCRL	;DIMINISH SCREEN SIZE TO MAKE ROOM
	SUB B
	STA SCRL
	RET
NOHELP: LXI H,0		;SET UP FOR NO HELP
	XRA A
	STA HSCRL
	STA HSFLG
	RET

MSGR:	MOV A,M
	CPI 3
	RZ
	MOV C,M
	CALL COUT
	INX H
	JMP MSGR

RDYN:	PUSH B
	MVI B,0FFH	;FOR DEFAULT
	MVI A,20H
	CALL CONA
RDYLP:	CALL CIN	;WAIT FOR A CR
	CPI 0DH
	JZ RDYNDN
	ANI 5FH
	CPI 'Y'
	JZ RDST
	CPI 'N'
	JNZ RDYLP
RDST:	MOV B,A
	MVI A,8
	CALL CONA
	MOV A,B
	CALL CONA
	JMP RDYLP
RDYNDN: MOV A,B		;RET THE KEY BEFORE CR
	POP B
	ORA A
	STC
	RM
	CPI 'Y'		;RET ZERO IF YES
	STC
	CMC
	RET
;
RDA:	PUSH H
	PUSH D
	PUSH B
RANOT:	LXI H,0
	MVI A,20H
	CALL CONA
	MVI A,'#'
	CALL CONA
RDHLLP: CALL RDDIG
	JC RANOT
	JZ RDDONE	;EXIT ON CR
	MVI D,0
	MOV E,A
	DAD H
	MOV B,H
	MOV C,L
	DAD H
	DAD H
	DAD B		;MULTIPLY BY 10
	DAD D
	JMP RDHLLP
RDDONE: MOV A,L
	POP B
	POP D
	POP H
	RET

RDDIG:	CALL CIN
	ANI 7FH
	CPI 0DH		;EXIT?
	RZ
	CPI 7FH
	STC
	RZ
	CPI 8
	STC
	RZ
	SUI '0'		;ERROR IF LESS THAN 0
	JC RDDIG
	CPI 10		;OK IF 0-9
	CMC
	JC RDDIG
	PUSH PSW
	ADI '0'
	CALL CONA
	POP PSW
	STC
	CMC
	RET
;
CONA:	PUSH PSW
	PUSH B
	MOV C,A
	MVI A,0CH
	CALL CPMGO
	POP B
	POP PSW
	RET
;
;
TMSG0:	DB  'SPELLBINDER for the JONOS computer'
	DB  0DH,0AH,0AH
	DB	'0   STANDARD CONTROL SET',0DH,0AH
	DB	'1   SPECIAL FUNCTION KEYPAD',0DH,0AH
	DB	0DH,0AH
	DB	'KEYBOARD STYLE: '
	DB 3
TMSG3	DB	0DH,0AH,0DH,0AH
  DB 'AFTER YOU ENTER SPELLBINDER, YOU MAY SAVE THE CONFIGURED'
  DB 0DH,0AH
  DB 'PROGRAM ON DISK BY EXITING SPELLBINDER WITH THE "X"'
  DB 0DH,0AH
  DB 'COMMAND.  THEN DO A "SAVE '
  DB 3
TMSG4	DB	' SB.COM"',0DH,0AH
 DB 0DH,0AH,'HIT A KEY TO CONTINUE OR ESC TO RESTART'
	DB	3
TMSG5	DB	0DH,0AH,0DH,0AH
	DB	'DO YOU WANT THE USER GUIDES? (Y/N) ',3
TMSG6:
	DB	0DH,0AH,0DH,0AH
	DB	'1      DIABLO 1610, NEC 5515',0DH,0AH
	DB	'2      QUME SPRINT 5, C.ITOH, DIABLO 630',0DH,0AH
	DB	'3      NEC 5510',0DH,0AH
	DB	0DH,0AH,'PRECISION PRINTER: '
	DB 3
KMSG0:
  DB 6
  DB ' '
  DB ''
  DB 0DH,6
  DB '  edit/comm   insert   prev   next  '
  DB 'mode keys:  change  back  forw  del'
  DB 0DH,06H
  DB ' Ʊ indent  Ʋ dec tab  Ƴ hyphen  ƴ re'
  DB 'write  Ƶ mark  ƶ continue  ESC = more'

  DB 0


TTLENG	EQU 71		;DEFINE TABLE LENGTH
KTLENG	EQU 37
PTLENG	EQU 33
NTERMS	EQU 13		;NUMBER OF TERMINALS AVAILABE
PTABS	EQU	$
;
;
; KEYBOARD INPUT
JONOS:	DB 1,1,82H,0,0,0,0,0
	DB 0C1H,9,0B1H,01AH,0C3H,000H,0B9H,000H
	DB 8,0CH,1EH,0AH,0BH,0DH,0B8H,0B7H
	DB 1BH,07FH,12H,0C4H,0C5H,0C2H,0B0H,0B4H
	DB 0B2H,0B3H,0C6H,10H,80H
	DB 24
	DB 50H
	DB	0FH,5,4,0,0,5FH

	DB	1EH,0,0
	DB	1BH,2AH,0
	DB	0BH,0,0
	DB	0AH,0,0
	DB	08H,0,0
	DB	0CH,0,0
	DB	1BH,54H,0
	DB	1BH,59H,0
	DB	1BH,28H,0
	DB	1BH,29H,0
	DB	1BH,23H,0
	DB	1BH,22H,0
	DB	0DH,0,0
	DB	0DH,0AH,0
	DB	07,0,0
	DB	0,0,0
	DB	0,0,0,0,0,0,0,0,0
	DB	1BH,3DH,0
	DB	1
	DB	20H
	DB	20H
;
;
;	PRECISION PRINTER FUNCTION TABLES
;
;
;
HTABLE	DB 1,9FH,1,9EH,1,0B6H,0B5H,0AH,8AH,120,89H,1
	DB 0DH,1BH,1FH,0DH,1BH,1EH,9,0,0
	DB 1BH,42H,0,1BH,41H,0
	DB 0,0,0,0,0,0
QTABLE	DB 2,9FH,1,9EH,1,0B6H,0B5H,0AH,8AH,120,000,1
	DB 1BH,1AH,'I',0,0,0,0,0,0
	DB 1BH,42H,0,1BH,41H,0
	DB 0,0,0,0,0,0
NTABLE	DB 3,0DDH,'@',0DDH,'O',0BCH,0BEH,0AH,0B9H,15,0,0
	DB 1BH,3DH,0,0,0,0,0,0,0
	DB 1BH,34H,0,1BH,33H,0
	DB 0,0,0,0,0,0

	END
