;File:	RASM6.ASM
;Edit date:	86/10/04.
;Serial number 7
;
;	RP/M2 Assembler main program.
;
ASMORG	EQU	3100H	;main program module
;
IOMORG	EQU	0300H	;input/output module
SCNORG	EQU	2400H	;token scanner module
STMORG	EQU	2700H	;symbol table processor module
MTPORG	EQU	2A00H	;mnemonic table processor module
EVAORG	EQU	2D00H	;expression evaluation module
;
;	Locations in the I/O module.
;
IOMPRS	EQU	IOMORG+00H	;program preset
IOMRIF	EQU	IOMORG+03H	;reset the input file
IOMMSG	EQU	IOMORG+12H	;console message out
IOMWPL	EQU	IOMORG+15H	;write print line & clear buffer
IOMPER	EQU	IOMORG+18H	;put error flag in column 1
IOMPHB	EQU	IOMORG+1BH	;put hex byte to object file
IOMEOR	EQU	IOMORG+1EH	;process end of assembly run
IOMRFN	EQU	IOMORG+24H	;restore original source filename
IOMPIF	EQU	IOMORG+27H	;preset the RDLIB file
IOMCSF	EQU	IOMORG+2AH	;change RDLIB source file
;
;	Location in the token scanner module.
;
SCNINS	EQU	SCNORG+03H	;preset token scanner
SCNSNT	EQU	SCNORG+06H	;scan next token
;
;	Locations in the symbol table processor module.
;
STMPST	EQU	STMORG+03H	;preset symbol table
STMSFS	EQU	STMORG+06H	;search for symbol
STMCSF	EQU	STMORG+09h	;check symbol found
STMEST	EQU	STMORG+0CH	;enter symbol into table
STMSTY	EQU	STMORG+0FH	;set symbol type
STMGTY	EQU	STMORG+12H	;get symbol type
STMSSV	EQU	STMORG+15H	;set symbol value
STMGSV	EQU	STMORG+18H	;get symbol value
;
;	Locations in mnemonics processor module.
;
MTPGMV	EQU	MTPORG+06H	;get mnemonic type & value
;
;	Locations in the expression evaluation module.
;
EVASOF	EQU	EVAORG+03H	;scan operand field
EVAMUL	EQU	EVAORG+06H	;HL = DE * HL
EVADIV	EQU	EVAORG+09H	;DE = HLDE / BC
;
;
;	Locations on page 1.
;	Print line buffer.
;
PLBFWA	EQU	010CH	;line buffer fwa
PLBSIZ	EQU	120	;line length
PLBFBP	EQU	PLBFWA+PLBSIZ	;buffer fill pointer
FPRCOL	EQU	16	;source line image starting column
;
;	Assembler control data.
;
TOKEN	EQU	PLBFBP+1	;current token
VALUE	EQU	TOKEN+1		;binary value
ACCLEN	EQU	VALUE+2		;accumulator length
ACCUM	EQU	ACCLEN+1	;accumulator fwa
ACCSIZ	EQU	64
EVALUE	EQU	ACCUM+ACCSIZ	;expression value
SYTOP	EQU	EVALUE+2	;current symbol table top
SYMAX	EQU	SYTOP+2		;symbol table lwa + 1
PASSN	EQU	SYMAX+2		;pass number, 0 or 1
HEXPC	EQU	PASSN+1		;current hex fill address
LOCCN	EQU	HEXPC+2		;assembler's location counter
SYBAS	EQU	LOCCN+2		;symbol table base
SYADR	EQU	SYBAS+2		;current symbol address
FIXED	EQU	7		;collision+length+value
;
;	Ascii character codes.
;
cr	EQU	0DH		;carriage return
lf	EQU	0AH		;line feed
eof	EQU	1AH		;control-z = end of file
tab	EQU	09H		;tabulate
;
;	Token definitions.
;
IDENT	EQU	1	;identifier
NUMBR	EQU	2	;number
STRNG	EQU	3	;string
SPECL	EQU	4	;other
;
;	Symbol types.
;
TCLB	EQU	 1	;code label
TDLB	EQU	 2	;data label
TEQU	EQU	 4	;defined by EQU
TSET	EQU	 5	;defined by SET
TMAC	EQU	 6	;defined by MACRO
TEXT	EQU	 8	;defined by EXT
TREF	EQU	11	;defined by REF
TGBL	EQU	12	;defined by GLOBAL
;
XBASE	EQU	0	;start of operator types
LOPER	EQU	15	;last operator
RT	EQU	16	;register type
PT	EQU	RT+1	;pseudo-operation type
OBASE	EQU	PT+1	;start of operations types
O1	EQU	OBASE+1	;first operation
O16	EQU	O1+15	;last operation
PENDIF	EQU	5	;code for pseudo-op ENDIF
;
;	Assembler main program.
;
	ORG	ASMORG
	XRA	A	;reset pass number
	STA	PASSN
	CALL	STMPST	;reset symbol table
	JMP	SCN
;
;	Local data space.
;
SYLAB:	DW	0	;line label address
ENDPC:	DW	0	;value from optional END statement
NXTHEX:	DB	0	;next list hex position
SWFLG:	DB	0	;1=switch to include @ end of line
;
;	ERR - Issue register error.
;
ERR:	PUSH	PSW
	MVI	A,'R'
ERR1:	PUSH B ! PUSH D ! PUSH H
	CALL	IOMPER
	POP H ! POP D ! POP B
	POP	PSW
	RET
;
ERV:	PUSH PSW ! MVI A,'V' ! JMP ERR1	;issue value error
ERD:	PUSH PSW ! MVI A,'D' ! JMP ERR1	;issue data error
ERP:	PUSH PSW ! MVI A,'P' ! JMP ERR1	;issue phase error
ERL:	PUSH PSW ! MVI A,'L' ! JMP ERR1	;issue label error
ERN:	PUSH PSW ! MVI A,'N' ! JMP ERR1	;issue not implemented error
;
;	DMH - Calulate HL = DE - HL.
;
DMH:	MOV A,E ! SUB L ! MOV L,A
	MOV A,D ! SBB H ! MOV H,A
	RET
;
;	CHD - Compare DE:HL.
;	Exit	 Z = true, if HL = DE
;		 C = true, if HL > DE
;
CHD:	MOV A,D ! CMP H ! RNZ
	MOV A,E ! CMP L ! RET
;
;	AWT - Access a word table.
;	ABT - Access a byte table.
;
;	Entry	HL = table fwa
;		 A = ordinal
;	Exit	DE = word table entry
;		 E = byte table entry
;		HL = table entry address
;
AWT:	ADD	A	;ordinal*2
ABT:	MOV	E,A
	MVI	D,0
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	H
	RET
;
;	SLC - Sync location counters.
;	Set LOCCN = HEXPC
;
SLC:	LHLD	HEXPC
	SHLD	LOCCN
	RET
;
;	SLA - Set label address.
;
SLA:	LHLD	SYLAB
	SHLD	SYADR
	CALL	STMCSF	;check symbol found
	RET
;
;	FLV - Fill label value.
;	If label found, set label value = location counter.
;
FLV:	CALL	SLA
	RZ		;If no label
;
	LXI	H,0	;reset for next label
	SHLD	SYLAB
	LDA	PASSN
	ORA	A
	JNZ	FLV1	;If second pass
;
;	Process first pass.
;	Enter this label into the symbol table.
;
	CALL	STMGTY	;get symbol type
	PUSH	PSW
	ANI	07H
	CNZ	ERL	;If already defined, label error
;
	POP	PSW	;set type=code label
	ORI	TCLB
	CALL	STMSTY
	LHLD	LOCCN	;set value=location counter
	CALL	STMSSV
	RET
;
;	Process second pass.
;	Check defined value.
;
FLV1:	CALL	STMGTY	;get symbol type
	ANI	07H
	CZ	ERP	;If undefined, issue phase error
;
;	The label must equal current location counter.
;
	CALL	STMGSV	;get symbol value
	XCHG
	LHLD	LOCCN
	CALL	CHD	;compare symbol:location counter
	CNZ	ERP	;If not the same, issue phase error
	RET
;
;	FHX - Fill hex object code.
;	Entry	 A = object code byte
;
FHX:	MOV	B,A
;
;	FHX1 - Fill hex object code.
;	Entry	 B = object code byte
;
FHX1:	LDA	PASSN
	ORA	A
	MOV	A,B
	JZ	FHX2	;If first pass
;
;	Process second pass.
;	Write hex file and print hex list.
;
	PUSH	B	;save object code byte
	CALL	IOMPHB	;put byte to object file
;
;	List hex byte in print file.
;
	LDA	PLBFWA+1
	CPI	' '
	LHLD	LOCCN
	CZ	PAD1	;If starting a new line, pack location
;
	LDA	NXTHEX
	CPI	FPRCOL
	POP	B
	JNC	FHX2	;If hex print space not available
;
;	Show this object code byte in the print line.
;
	MOV	A,B
	CALL	PHB	;put hex byte to print line
FHX2:	LHLD	HEXPC	;advance hex location counter
	INX	H
	SHLD	HEXPC
	RET
;
;	FAD - Fill hex word.
;	Entry	HL = object code word
;
FAD:	PUSH	H
	MOV	B,L	;put low byte
	CALL	FHX1
	POP	H
	MOV	B,H	;put high byte
	JMP	FHX1
;
;	CVH - Convert binary to Ascii hex.
;	Entry	 A, low 4 bits = binary
;	Exit	 A = Ascii hex digit
;
CVH:	ADI	90H
	DAA
	ACI	40H
	DAA
	RET
;
;	PHB - Pack hex byte.
;	Entry	 A = byte
;
PHB:	PUSH	PSW	;pack high digit
	RAR ! RAR ! RAR ! RAR
	ANI	0FH
	CALL	PHD
	POP	PSW	;pack low digit
	ANI	0FH
;
;	PHD - Pack hex digit.
;	Entry	 A, low 4 bits = digit
;
PHD:	CALL	CVH	;convert binary to Ascii
	LXI	H,NXTHEX	;advance pack location
	MOV	E,M
	MVI	D,0
	INR	M
	LXI	H,PLBFWA	;buffer fwa
	DAD	D
	MOV	M,A
	RET
;
;	PAD - Pack address.
;
PAD:	LHLD	LOCCN
;
;	Pack address field from HL.
;
PAD1:	XCHG
	LXI	H,NXTHEX	;next pack location
	PUSH	H
	MVI	M,1
	MOV	A,D	;pack high byte
	PUSH	D
	CALL	PHB
	POP	D	;pack low byte
	MOV	A,E
	CALL	PHB
	POP	H	;skip one space
	INR	M
	RET
;
;	CDL - Check delimiter.
;
CDL:	LDA	TOKEN
	CPI	SPECL
	CNZ	ERD	;If not delimter, issue data error
;
	LDA	ACCUM
	CPI ',' ! RZ	;If comma
	CPI ';' ! RZ	;If semicolon
	CPI cr
	CNZ	ERD	;If not comma, semicolon, or cr
	RET
;
;	GWV - Get word expression value.
;	Exit	HL = expression value
;
GWV:	PUSH	B
	CALL	SCNSNT	;start operand scan
	CALL	EVASOF	;evaluate operand field
	LHLD	EVALUE
	POP	B
	RET
;
;	GBV - Get byte expression value.
;	Exit	 A = expression value
;
GBV:	CALL	GWV	;get word value
	MOV	A,H
	ORA	A
	CNZ	ERV	;If > 8 bits
;
	MOV	A,L
	RET
;
;	GRV - Get register value.
;	Exit	 A, low 3 bits = register name
;
GRV:	CALL	GBV	;get byte value
	CPI	08H
	CNC	ERV	;If > 3 bits, issue value error
;
	ANI	07H
	RET
;
;	GSR - Get and shift register value.
;	Exit	 A = register name shifted 3 bits left
;		 C = A
;
GSR:	CALL	GRV	;get register name
	RAL ! RAL ! RAL
	ANI	111000B
	MOV	C,A
	RET
;
;	GDR - Get index register value.
;	Entry	 B = opcode
;	Exit	to FHX to emit object code
;
GDR:	CALL	GSR	;get shifted register value
	ANI	001000B
	CNZ	ERR	;If A,C,E, or L, issue register error
;
	MOV	A,C	;force B, D, or H
	ANI	110000B
	ORA	B
	JMP	FHX	;go emit object code
;
;	PBV - Put byte object code value.
;
PBV:	CALL	GBV	;get byte expression value
	JMP	FHX	;go emit object code
;
;	PWV - Put word object code value.
;
PWV:	CALL	GWV	;get word expression value
	JMP	FAD	;go emit object word
;
;	CXD - Check expression delimiter.
;	Check for comma following expression.
;
CXD:	PUSH PSW ! PUSH B
	LDA	TOKEN
	CPI	SPECL
	JNZ	CXD1	;If not special char
;
	LDA	ACCUM
	CPI	','
	JZ	CXD2	;If comma found
;
;	Issue error "C" for missing comma.
;
CXD1:	MVI	A,'C'
	CALL	IOMPER
;
CXD2:	POP B ! POP PSW
	RET
;
;	Assembler main program.
;
SCN:	CALL	SCNINS	;preset token scanner
	CALL	IOMRIF	;reset the input file
	LXI	H,0000	;reset label found
	SHLD	SYLAB
	SHLD	HEXPC	;reset location counters
	SHLD	LOCCN
	SHLD	ENDPC
;
;	Scan next item.
;
SCN1:	CALL	SCNSNT	;scan next token
SCN2:	LDA	TOKEN
	CPI	NUMBR
	JZ	SCN1	;If leading number, skip it
;
	CPI	SPECL
	JNZ	SCN3	;If not a special char
;
;	Process leading special character.
;
	LDA	ACCUM
	CPI	'*'
	JNZ	ELC	;If not Processor Tech comment
;
;	We have leading "*".
;	Allow no preceding label.
;
	CALL	SLA	;set label address
	JNZ	ELC4	;If labelled, issue statement error
;
	JMP	ELC2	;go skip comment line
;
;	Check identifier.
;
SCN3:	CPI	IDENT
	JNZ	ELC4	;If not identifier, issue statement error
;
;	Identifier found.
;	May be label, opcode, or macro.
;	Check mnemonic tables.
;
	CALL	MTPGMV	;get A=type, B=value
	JZ	SCN6	;If mnemonic found
;
;	Item not found in mnemonic table.
;	Check the symbol table.
;
	CALL	STMSFS	;search for symbol
	CALL	STMCSF
	JNZ	SCN4	;If symbol found
;
;	Enter this item in the symbol table.
;
	CALL	STMEST	;enter into symbol table
	LDA	PASSN
	ORA	A
	CNZ	ERP	;If 2nd pass, issue phase error
;
	JMP	SCN5
;
;	Item found in symbol table.
;	Check symbol type.
;
SCN4:	CALL	STMGTY	;get symbol type
	CPI	TMAC
	JNZ	SCN5	;If not macro
;
;	Expand macro.
;
	CALL	ERN	;issue not implemented error
	JMP	ELC2
;
;	Verify first label.
;
SCN5:	LHLD	SYLAB
	MOV A,L ! ORA H
	CNZ	ERL	;If already labelled, issue label error
;
	LHLD	SYADR	;mark label found
	SHLD	SYLAB
;
;	Process optional ":".
;
	CALL	SCNSNT	;scan next token
	LDA	TOKEN
	CPI	SPECL
	JNZ	SCN2	;If not special char
;
	LDA	ACCUM
	CPI	':'
	JNZ	SCN2	;If not ":"
	JMP	SCN1
;
;	Process the operation.
;	A = operation code
;
SCN6:	LXI	H,PTTAB
	CPI PT ! JNZ SCN7	;If not pseudo-op
;
	MOV	A,B
	DCR	A
	JMP	SCN8
;
;	Process real operation.
;
SCN7:	LXI	H,OPTAB
	SUI	O1
	CPI	O16
	JNC	ELC4	;If out of range, issue statement error
;
;	HL = .process address table
;	 A = processor ordinal
;
SCN8:	CALL	AWT
	XCHG
	PCHL		;go to processor
;
;	Pseudo-op processor addresses.
;
PTTAB	EQU	$
	DW	PPTDB	;1	DB
	DW	PPTDS	;2	DS
	DW	PPTDW	;3	DW
	DW	PTEND	;4	END
	DW	PTEIF	;5	ENDIF
	DW	PTENM	;6	ENDM
	DW	PTEQU	;7	EQU
	DW	PPTIF	;8	IF
	DW	PTINC	;9	RDLIB
	DW	PTORG	;A	ORG
	DW	PTSET	;B	SET
	DW	PTTTL	;C	TITLE
	DW	PTTTL	;D	(spare)
	DW	PTTTL	;E	(spare)
	DW	PTTTL	;F	(spare)
;
;	Real operation processor addresses.
;
OPTAB	EQU	$
	DW	RTNOP	;13  19	simple
	DW	RTLXI	;14  20	LXI
	DW	RTDAD	;15  21	DAD
	DW	RTPOP	;16  22	PUSH POP
	DW	RTJMP	;17  23	JMP  CALL
	DW	RTMOV	;18  24	MOV
	DW	RTMVI	;19  25	MVI
	DW	RTADI	;1A  26	A immediate
	DW	RTLDX	;1B  27	LDAX STAX
	DW	RTLDA	;1C  28	LHLD SHLD LDA STA
	DW	RTADB	;1D  29	A register
	DW	RTINR	;1E  30	INR  DCR
	DW	RTINX	;1F  31	INX  DCX
	DW	RTRST	;20  32	RST
	DW	RTOUT	;21  33	IN   OUT
	DW	RTCLN	;22  34 CALLN
;
;	Processors return to one of the following two locations.
;
;	Fill hex object code from A.
;
SCN9:	CALL	FHX
;
;	Advance the location counter.
;
SCN10:	CALL	FLV	;fill label value
	CALL	SLC	;set LOCCN = HEXPC
;
;	ELC - End of line check.
;
ELC:	CALL	FLV	;fill label value
	LDA	TOKEN
	CPI	SPECL
	JNZ	ELC4	;If not special char
;
	LDA	ACCUM
	CPI	cr
	JNZ	ELC1	;If not end of line
;
;	Carriage return found.
;	Scan processes lf, and pushes the line.
;
	CALL	SCNSNT	;scan next token
	LXI	H,SWFLG	;check include file switch
	CALL	IOMCSF
	CNZ	SCNINS	;If switched to new source file
	JMP	SCN1
;
;	Check for beginning of comment field.
;
ELC1:	CPI	';'
	JNZ	ELC3	;If not comment field
;
;	Process comment field.
;
	CALL	FLV	;in case of labelled empty line
;
;	Scan to end of line.
;
ELC2:	CALL	SCNSNT	;scan next token
	LDA	TOKEN
	CPI	SPECL
	JNZ	ELC2	;loop to a special char
;
	LDA	ACCUM
	CPI  lf ! JZ SCN1	;If line feed
	CPI eof ! JZ PEP	;If end of file
	CPI '!' ! JZ SCN1	;If logical end of line
	JMP	ELC2		;loop to end of line
;
;	Check logical end of line.
;
ELC3:	CPI  '!' ! JZ SCN1	;If logical end of line
	CPI  eof ! JZ PEP	;If end of file
;
;	Issue statement error.
;
ELC4:	MVI	A,'S'
	CALL	IOMPER
	JMP	ELC2
;
;	PEP - Process end of pass.
;
PEP:	LXI	H,PASSN	;advance pass
	MOV	A,M
	INR	M
	ORA	A
	JZ	PEP3	;If starting second pass
;
;	Process end of second pass.
;
	CALL	SCNSNT	;clear last line feed
	CALL	PAD	;write last address
	LXI	H,PLBFWA+5
	MVI	M,cr
	INX	H
	MVI	M,lf
	INX	H
	MVI	M,00
	LXI	D,PLBFWA+1	;display last address
	CALL	IOMMSG
;
;	Calculate symbol table space remaining.
;
;	Display a use factor = bytes used / pages available.
;
;
	LHLD	SYTOP
	XCHG
	LHLD	SYBAS
	CALL	DMH	;HL=table top-table base
	PUSH	H
	LHLD	SYMAX
	XCHG
	LHLD	SYBAS
	CALL	DMH	;HL=number of bytes available
	MOV C,H ! MVI B,0	;/256
	LXI	H,0
	POP	D	;DE=HLDE/BC
	CALL	EVADIV
	XCHG
	CALL	PAD1	;print use factor
	LXI	H,PLBFWA+5
	LXI	D,PEPA	;" use factor"
PEP1:	LDAX	D
	ORA	A
	MOV	M,A
	JZ	PEP2	;If end of message
;
	INX	H
	INX	D
	JMP	PEP1
;
PEP2:	LXI	D,PLBFWA+2	;display use factor
	CALL	IOMMSG
	LHLD	ENDPC		;mark ending location
	SHLD	HEXPC
	JMP	IOMEOR		;go close files
;
;	Restore the original source filename.
;
PEP3:	CALL	IOMRFN
	JMP	SCN
;
PEPA:	DB	'H  Use factor',cr,0
;
;	Process pseudo-op DB.
;
PPTDB	EQU	$
	CALL	FLV	;fill label from location counter
PDB1:	CALL	SCNSNT	;scan next token
	LDA	TOKEN
	CPI	STRNG
	JNZ	PDB4	;If not string
;
	LDA	ACCLEN
	DCR	A
	JZ	PDB4	;If string length=1
;
	MOV	B,A
	INR B ! INR B
	LXI	H,ACCUM
PDB2:	DCR	B
	JZ	PDB3	;If end of string
;
	PUSH	B
	MOV	B,M	;get char
	INX	H
	PUSH	H
	CALL	FHX1	;put byte to object file
	POP	H
	POP	B
	JMP	PDB2
;
;	Process end of string.
;
PDB3:	CALL	SCNSNT	;scan next token
	JMP	PDB5
;
;	Process one-byte string, or non-string data.
;
PDB4:	CALL	EVASOF	;evaluate operand field
	LHLD	EVALUE
	MOV	A,H
	ORA	A
	CNZ	ERD	;If > 8 bits, issue data error
;
	MOV	B,L	;emit object code byte
	CALL	FHX1
;
;	Process end of expression.
;
PDB5:	CALL	SLC	;sync location counters
	CALL	CDL	;check the delimiter
	CPI	','
	JZ	PDB1	;If another data item present
;
	JMP	ELC	;go check end of line
;
;	Process pseudo-op DS.
;
PPTDS	EQU	$
	CALL	FLV	;fill label value
	CALL	PAD	;print address
	CALL	GWV	;HL=word expression value
	XCHG
	LHLD	LOCCN	;advance location counter
	DAD	D
	SHLD	LOCCN
	SHLD	HEXPC
	JMP	ELC	;go check end of line
;
;	Process pseudo-op DW.
;
PPTDW	EQU	$
	CALL	FLV	;fill label value
PDW1:	CALL	GWV	;HL=word expression value
	PUSH	H
	MOV B,L ! CALL FHX1	;send low hex byte
	POP	H
	MOV B,H ! CALL FHX1	;send high hex byte
	CALL	SLC	;sync location counters
	CALL	CDL	;check delimiter
	CPI	','
	JZ	PDW1	;If another data item present
;
	JMP	ELC	;go check end of line
;
;	Process pseudo-op END.
;
PTEND	EQU	$
	CALL	FLV	;fill label value
	CALL	PAD	;print address
	LDA	PLBFWA	;check error flag
	CPI	' '
	JNZ	ELC	;If no expression present
;
	CALL	GWV	;HL=word expression value
	LDA	PLBFWA
	CPI	' '
	JNZ	PND1	;If no expression
;
	SHLD	ENDPC	;save expression value
PND1:	MVI	A,' '	;clear any error flag
	STA	PLBFWA
	CALL	SCNSNT	;clear cr
	LDA	TOKEN
	CPI	SPECL
	JNZ	ELC4	;If not special char
;
	LDA	ACCUM
	CPI	lf
	JNZ	ELC4	;If not line feed
;
	JMP	PEP	;go process end of pass
;
;	Process pseudo-op ENDIF.
;
PTEIF	EQU	$
	JMP	PTSCN
;
;	Process pseudo-op ENDM.
;
PTENM	EQU	$
	CALL	ERN	;issue not implemented error
	JMP	PTSCN
;
;	Process pseudo-op EQU.
;
PTEQU	EQU	$
	CALL	SLA	;get label value
	JZ	ELC4	;If no label, issue statement error
;
	LHLD	LOCCN	;save current location counter
	PUSH	H
	CALL	GWV	;HL=word expression value
	SHLD	LOCCN
	CALL	FLV	;fill label value
	CALL	PAD1	;fill address field
	LXI	H,PLBFWA+6
	MVI	M,'='
	POP	H	;restore the location counter
	SHLD	LOCCN
	JMP	ELC	;go check end of line
;
;	Process pseudo-op IF.
;
PPTIF	EQU	$
	CALL	FLV	;fill label value
	CALL	GWV	;HL=word expression value
	LDA	PLBFWA
	CPI	' '
	JNZ	ELC	;If error flag set
;
	MOV	A,L
	RAR
	JC	ELC	;If expression TRUE
;
;	Expression is false.
;	Skip to ENDIF.
;
PIF1:	CALL	SCNSNT	;scan next token
	LDA	TOKEN
	CPI	SPECL
	JNZ	PIF2	;If not special char
;
	LDA	ACCUM
	CPI	eof
	MVI	A,'B'
	CZ	IOMPER	;If eof, issue "balance" error
;
	JZ	PEP	;If eof, process end of pass
;
	JMP	PIF1	;loop to ENDIF
;
;	Check identifier.
;
PIF2:	CPI	IDENT
	JNZ	PIF1	;loop to ENDIF
;
;	Identifier found.  Get mnemonic value.
;
	CALL	MTPGMV
	JNZ	PIF1	;If mnemonic not found
;
	CPI	PT
	JNZ	PIF1	;If not pseudo-op
;
	MOV	A,B
	CPI	PENDIF
	JNZ	PIF1	;If not ENDIF
;
;	ENDIF found.
;
	JMP	PTSCN
;
;	Process pseudo-op RDLIB.
;	RDLIB  'filename'
;
PTINC	EQU	$
	CALL	SCNSNT	;scan next token
	LDA	TOKEN
	CPI	STRNG
	JNZ	ELC4	;If not string
;
;	Request change source file at next end of line.
;
	MVI	A,1
	STA	SWFLG
	CALL	IOMPIF	;preset include file
	CALL	SCNSNT	;scan next token
	JMP	ELC	;go check end of line
;
;	Process pseudo-op ORG.
;
PTORG	EQU	$
	CALL	GWV	;HL=word expression value
	LDA	PLBFWA
	CPI	' '
	JNZ	ELC	;If error flag set
;
	SHLD	LOCCN	;set location counters
	SHLD	HEXPC
	CALL	FLV	;fill label value
	CALL	PAD	;fill address field
	JMP	ELC	;go check end of line
;
;	Process pseudo-op SET.
;
PTSET	EQU	$
	CALL	SLA	;set label value
	JZ	ELC4	;If not labelled, issue statement error
;
	CALL	STMGTY	;get symbol type
	CPI	TSET
	CNZ	ERL	;If not SET type, issue label error
;
	MVI	A,TSET	;set symbol type to SET
	CALL	STMSTY
	CALL	GWV	;HL=word expression value
	PUSH	H
	CALL	SLA	;re-address the label
	POP	H
	CALL	STMSSV
	LXI	H,0	;prevent label processing
	SHLD	SYLAB
	JMP	ELC	;go check end of line
;
;	Process pseudo-op TITLE.
;
PTTTL	EQU	$
	CALL	ERN	;issue not implemented error
;
;	Process end of pseudo-op.
;	Scan to next token.
;
PTSCN	EQU	$
	CALL	SCNSNT	;scan next token
	JMP	ELC	;go check end of line
;
;	Process real operations.
;
;	Process simple single byte op-code.
;
RTNOP	EQU	$
	CALL	FHX1	;emit object code byte
	CALL	SCNSNT	;scan next token
	JMP	SCN10	;go advance location counter
;
;	Process LXI x,w.
;
RTLXI	EQU	$
	CALL	GDR	;get x and emit with opcode
	CALL	CXD	;check delimiter
	CALL	PWV	;emit word value w
	JMP	SCN10
;
;	Process DAD x.
;
RTDAD	EQU	$
	CALL	GDR	;get x and emit with opcode
	JMP	SCN10
;
;	Process PUSH x and POP x.
;
RTPOP	EQU	$
	CALL	GSR	;get x
	CPI	111000B
	JZ	RTP1	;If x=PSW
;
;	x must be B, D, or H.
;
	ANI	001000B
	CNZ	ERR	;If not, issue register error
;
RTP1:	MOV	A,C	;force B, D, or H
	ANI	110000B
	ORA	B
	JMP	SCN9	;go emit object code
;
;	Process JMP w  and  CALL w.
;
RTJMP	EQU	$
	CALL	FHX1	;emit opcode
	CALL	PWV	;emit w
	JMP	SCN10
;
;	Process MOV r,s.
;
RTMOV	EQU	$
	CALL	GSR	;get shifted r
	ORA	B	;combine with opcode
	MOV	B,A
	CALL	CXD	;check separator
	CALL	GRV	;get s
	ORA	B
	JMP	SCN9	;go emit object code
;
;	Process MVI r,b.
;
RTMVI	EQU	$
	CALL	GSR	;get shifted r
	ORA	B	;combine with opcode
	CALL	FHX	;emit opcode
	CALL	CXD	;check separator
	CALL	PBV	;get and emit b
	JMP	SCN10
;
;	Process e.g. ADI b.
;
RTADI	EQU	$
	CALL	FHX1	;emit opcode
	CALL	PBV	;get and emit b
	JMP	SCN10
;
;	Process LDAX x  and  STAX x.
;
RTLDX	EQU	$
	CALL	GSR	;get shifted x
	ANI	101000B
	CNZ	ERR	;If not B or D
;
	MOV	A,C	;force B or D
	ANI	010000B
	ORA	B	;combine with opcode
	JMP	SCN9	;go emit opcode
;
;	Process LHLD w  SHLD w  LDA w  or  STA w.
;
RTLDA	EQU	$
	CALL	FHX1	;emit opcode
	CALL	PWV	;get and emit w
	JMP	SCN10
;
;	Process e.g. ADD r.
;
RTADB	EQU	$
	CALL	GRV	;get r
	ORA	B	;combine with opcode
	JMP	SCN9
;
;	Process  INR r  and  DCR r.
;
RTINR	EQU	$
	CALL	GSR	;get shifted r
	ORA	B
	JMP	SCN9	;go emit opcode
;
;	Process  INX x  and  DCX x.
;
RTINX	EQU	$
	CALL	GSR	;get shifted x
	ANI	001000B
	CNZ	ERR	;If not index or SP
;
	MOV	A,C	;force B, D, H, or SP
	ANI	110000B
	ORA	B
	JMP	SCN9	;go emit opcode
;
;	Process RST n.
;
RTRST	EQU	$
	CALL	GSR	;get shifted n
	ORA	B
	JMP	SCN9	;go emit opcode
;
;	Process  IN b  and  OUT b.
;
RTOUT	EQU	$
	CALL	FHX1	;emit opcode
	CALL	PBV	;get and emit b
	JMP	SCN10
;
;	Process CALLN b.
;
RTCLN	EQU	$
	CALL	FHX1	;emit opcode
	MVI	B,0EDH
	CALL	FHX1
	CALL	PBV	;get and emit b
	JMP	SCN10
;
;	Symbol table.
;
STFWA	EQU	($ AND 0FF00H) + 100H
